/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class EntityStatueInfo {
    private static final String ENTITY_NAME_TAG = "entityName";
    private static final String STATUE_ENTITY_NAME_TAG = "statueEntityName";
    private static final String OVERALL_TRANSFORM_TAG = "overallTransform";
    private static final String PART_TRANSFORMS_TAG = "partTransforms";
    private RenderType renderType = RenderType.ENTITY;
    private Entity entity = null;
    private ResourceLocation entityName = null;
    private boolean entityOnFire = false;
    private String statueEntityName = "Zombie";
    private Transform overallTransform = new Transform();
    private Map<String, Transform> partTransforms = new HashMap<String, Transform>();

    Optional<Entity> getRenderEntity(World world) {
        if (this.entity != null) {
            return Optional.of(this.entity);
        }
        if (this.entityName != null && world.field_72995_K) {
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.entityName);
            if (entityEntry == null) {
                this.entityName = null;
                return Optional.empty();
            }
            this.entity = entityEntry.newInstance(world);
            return Optional.of(this.entity);
        }
        return Optional.empty();
    }

    boolean isEntityOnFire() {
        return this.entityOnFire;
    }

    void setEntityOnFire(boolean entityOnFire) {
        this.entityOnFire = entityOnFire;
    }

    void resetEntityName() {
        this.entityName = null;
        this.entity = null;
    }

    @Nullable
    public ResourceLocation getEntityName() {
        return this.entityName;
    }

    void setEntityName(@Nullable ResourceLocation entityName) {
        this.entityName = entityName;
        this.entity = null;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.renderType = RenderType.byName(tag.func_74779_i("renderType"));
        if (tag.func_74764_b(STATUE_ENTITY_NAME_TAG)) {
            this.statueEntityName = tag.func_74779_i(STATUE_ENTITY_NAME_TAG);
            if (tag.func_74764_b(OVERALL_TRANSFORM_TAG)) {
                this.overallTransform = new Transform();
                this.overallTransform.deserializeNBT(tag.func_74775_l(OVERALL_TRANSFORM_TAG));
            }
            if (tag.func_74764_b(PART_TRANSFORMS_TAG)) {
                this.partTransforms = NBTHelper.getMap(tag.func_150295_c(PART_TRANSFORMS_TAG, 10), t -> t.func_74779_i("name"), t -> {
                    Transform transform = new Transform();
                    transform.deserializeNBT(t.func_74775_l("transform"));
                    return transform;
                });
            }
        } else if (tag.func_74764_b(ENTITY_NAME_TAG)) {
            this.setEntityName(new ResourceLocation(tag.func_74779_i(ENTITY_NAME_TAG)));
            this.setEntityOnFire(tag.func_74767_n("entityOnFire"));
        } else {
            this.setEntityName(null);
        }
    }

    public NBTTagCompound serializeNBT(NBTTagCompound tag) {
        tag.func_74778_a("renderType", this.renderType.func_176610_l());
        if (this.renderType == RenderType.ENTITY) {
            if (this.getEntityName() != null) {
                tag.func_74778_a(ENTITY_NAME_TAG, this.getEntityName().toString());
                tag.func_74757_a("entityOnFire", this.isEntityOnFire());
            }
        } else {
            tag.func_74778_a(STATUE_ENTITY_NAME_TAG, this.statueEntityName);
            tag.func_74782_a(OVERALL_TRANSFORM_TAG, (NBTBase)this.overallTransform.serializeNBT());
            tag.func_74782_a(PART_TRANSFORMS_TAG, (NBTBase)NBTHelper.mapToCompoundList(this.partTransforms, (t, name) -> t.func_74778_a("name", name), (t, transform) -> t.func_74782_a("transform", (NBTBase)transform.serializeNBT())));
        }
        return tag;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public void setPartTransform(String partName, Transform partTransform) {
        this.partTransforms.put(partName, partTransform);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public String getStatueEntityName() {
        return this.statueEntityName;
    }

    public Map<String, Transform> getPartTransforms() {
        return this.partTransforms;
    }

    public Transform getOverallTransform() {
        return this.overallTransform;
    }

    public void setOverallTransform(Transform transform) {
        this.overallTransform = transform;
    }

    public void setStatueEntityName(String name) {
        this.statueEntityName = name;
    }

    public static class Transform
    implements INBTSerializable<NBTTagCompound> {
        private float offsetX = 0.0f;
        private float offsetY = 0.0f;
        private float offsetZ = 0.0f;
        private float rotationX = 0.0f;
        private float rotationY = 0.0f;
        private float rotationZ = 0.0f;
        private float scale = 1.0f;

        public Transform() {
        }

        Transform(float offsetX, float offsetY, float offsetZ, float rotationX, float rotationY, float rotationZ, float scale) {
            this(offsetX, offsetY, offsetZ, rotationX, rotationY, rotationZ);
            this.scale = scale;
        }

        Transform(float offsetX, float offsetY, float offsetZ, float rotationX, float rotationY, float rotationZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.rotationX = rotationX;
            this.rotationY = rotationY;
            this.rotationZ = rotationZ;
        }

        public float getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(float offset) {
            this.offsetX = offset;
        }

        public float getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(float offsetY) {
            this.offsetY = offsetY;
        }

        public float getOffsetZ() {
            return this.offsetZ;
        }

        public void setOffsetZ(float offsetZ) {
            this.offsetZ = offsetZ;
        }

        public float getRotationX() {
            return this.rotationX;
        }

        public void setRotationX(float rotationX) {
            this.rotationX = rotationX;
        }

        public float getRotationY() {
            return this.rotationY;
        }

        public void setRotationY(float rotationY) {
            this.rotationY = rotationY;
        }

        public float getRotationZ() {
            return this.rotationZ;
        }

        public void setRotationZ(float rotationZ) {
            this.rotationZ = rotationZ;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            this.setNonDefaultValue(tag, "offsetX", this.offsetX);
            this.setNonDefaultValue(tag, "offsetY", this.offsetY);
            this.setNonDefaultValue(tag, "offsetZ", this.offsetZ);
            this.setNonDefaultValue(tag, "rotationX", this.rotationX);
            this.setNonDefaultValue(tag, "rotationY", this.rotationY);
            this.setNonDefaultValue(tag, "rotationZ", this.rotationZ);
            this.setNonDefaultValue(tag, "scale", this.scale, 1.0f);
            return tag;
        }

        private void setNonDefaultValue(NBTTagCompound tag, String tagName, float value) {
            this.setNonDefaultValue(tag, tagName, value, 0.0f);
        }

        private void setNonDefaultValue(NBTTagCompound tag, String tagName, float value, float defaultValue) {
            if (!MathUtils.epsilonEquals(value, defaultValue)) {
                tag.func_74776_a(tagName, value);
            }
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.offsetX = this.loadValue(nbt, "offsetX").orElse(Float.valueOf(0.0f)).floatValue();
            this.offsetY = this.loadValue(nbt, "offsetY").orElse(Float.valueOf(0.0f)).floatValue();
            this.offsetZ = this.loadValue(nbt, "offsetZ").orElse(Float.valueOf(0.0f)).floatValue();
            this.rotationX = this.loadValue(nbt, "rotationX").orElse(Float.valueOf(0.0f)).floatValue();
            this.rotationY = this.loadValue(nbt, "rotationY").orElse(Float.valueOf(0.0f)).floatValue();
            this.rotationZ = this.loadValue(nbt, "rotationZ").orElse(Float.valueOf(0.0f)).floatValue();
            this.scale = this.loadValue(nbt, "scale").orElse(Float.valueOf(1.0f)).floatValue();
        }

        private Optional<Float> loadValue(NBTTagCompound nbt, String name) {
            if (!nbt.func_74764_b(name)) {
                return Optional.empty();
            }
            return Optional.of(Float.valueOf(nbt.func_74760_g(name)));
        }
    }

    public static enum RenderType implements IStringSerializable
    {
        ENTITY("entity"),
        MODEL("model");

        private static final Map<String, RenderType> NAME_TYPE;
        private String name;

        private RenderType(String name) {
            this.name = name;
        }

        public static RenderType byName(String name) {
            return NAME_TYPE.getOrDefault(name, ENTITY);
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_TYPE = new HashMap<String, RenderType>();
            for (RenderType type : RenderType.values()) {
                NAME_TYPE.put(type.func_176610_l(), type);
            }
        }
    }
}

