/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;
import net.shadowmage.ancientwarfare.structure.util.LootHelper;

public class TileAdvancedLootChest
extends TileEntityChest
implements ISpecialLootContainer {
    private static final String LOOT_SETTINGS_TAG = "lootSettings";
    private LootSettings lootSettings = new LootSettings();

    public boolean fillWithLootAndCheckIfGoodToOpen(@Nullable EntityPlayer player) {
        return LootHelper.fillWithLootAndCheckIfGoodToOpen(this, player != null ? player : EntityTools.findClosestPlayer(this.field_145850_b, this.field_174879_c, 100));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lootSettings = LootSettings.deserializeNBT(compound.func_74775_l(LOOT_SETTINGS_TAG));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a(LOOT_SETTINGS_TAG, (NBTBase)this.lootSettings.serializeNBT());
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(LOOT_SETTINGS_TAG, (NBTBase)this.lootSettings.serializeNBT());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag.func_74764_b(LOOT_SETTINGS_TAG)) {
            this.lootSettings = LootSettings.deserializeNBT(tag.func_74775_l(LOOT_SETTINGS_TAG));
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a(LOOT_SETTINGS_TAG, (NBTBase)this.lootSettings.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(LOOT_SETTINGS_TAG)) {
            this.lootSettings = LootSettings.deserializeNBT(tag.func_74775_l(LOOT_SETTINGS_TAG));
        }
    }

    public ItemStack func_70301_a(int index) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return (ItemStack)this.func_190576_q().get(index);
        }
        return super.func_70301_a(index);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public void setLootSettings(LootSettings settings) {
        this.lootSettings = settings;
    }

    @Override
    public LootSettings getLootSettings() {
        return this.lootSettings;
    }
}

