/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class TileDraftingStation
extends TileEntity
implements ITickable,
IBlockBreakHandler {
    private static final String STRUCTURE_NAME_TAG = "structureName";
    private String structureName;
    private boolean isStarted;
    private List<StructureTemplate.BuildResource> buildResources = NonNullList.func_191196_a();
    private boolean isFinished;
    private int remainingTime;
    private int totalTime;
    public ItemStackHandler inputSlots = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileDraftingStation.this.func_70296_d();
        }
    };
    public ItemStackHandler outputSlot = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileDraftingStation.this.func_70296_d();
        }
    };

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.structureName != null && !StructureTemplateManager.getTemplate(this.structureName).isPresent()) {
            this.stopCurrentWork();
        }
        if (this.structureName == null || !this.isStarted) {
            return;
        }
        if (!this.isFinished && this.tryRemoveResource()) {
            this.isFinished = true;
        }
        if (this.isFinished && this.tryFinish()) {
            this.stopCurrentWork();
        }
    }

    private boolean tryRemoveResource() {
        for (int slot = 0; slot < this.inputSlots.getSlots(); ++slot) {
            ItemStack inventoryStack = this.inputSlots.getStackInSlot(slot);
            if (inventoryStack.func_190926_b() || !this.removeBuildResource(inventoryStack)) continue;
            inventoryStack.func_190918_g(1);
            if (!inventoryStack.func_190926_b()) break;
            this.inputSlots.setStackInSlot(slot, ItemStack.field_190927_a);
            break;
        }
        return this.buildResources.isEmpty();
    }

    private boolean removeBuildResource(ItemStack inventoryStack) {
        for (int i = 0; i < this.buildResources.size(); ++i) {
            StructureTemplate.BuildResource buildResource = this.buildResources.get(i);
            if (!InventoryTools.doItemStacksMatchRelaxed(buildResource.getStackRequired(), inventoryStack)) continue;
            ItemStack returnStack = buildResource.shrinkStackRequiredAndGetRemaining();
            if (!returnStack.func_190926_b()) {
                InventoryTools.insertOrDropItem((IItemHandler)this.inputSlots, returnStack, this.field_145850_b, this.field_174879_c.func_177984_a());
            }
            if (buildResource.isEmpty()) {
                this.buildResources.remove(i);
            }
            return true;
        }
        return false;
    }

    public void tryStart() {
        if (this.structureName != null && StructureTemplateManager.getTemplate(this.structureName) != null) {
            this.isStarted = true;
        }
    }

    private boolean tryFinish() {
        if (this.outputSlot.getStackInSlot(0).func_190926_b()) {
            ItemStack item = new ItemStack(AWStructureBlocks.STRUCTURE_BUILDER_TICKED);
            item.func_77983_a(STRUCTURE_NAME_TAG, (NBTBase)new NBTTagString(this.structureName));
            this.outputSlot.setStackInSlot(0, item);
            return true;
        }
        return false;
    }

    public String getCurrentTemplateName() {
        return this.structureName;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public List<ItemStack> getNeededResources() {
        return this.buildResources.stream().map(StructureTemplate.BuildResource::getStackRequired).collect(Collectors.toList());
    }

    public void stopCurrentWork() {
        this.structureName = null;
        this.buildResources.clear();
        this.remainingTime = 0;
        this.isFinished = false;
        this.isStarted = false;
        this.func_70296_d();
    }

    public void setTemplate(String templateName) {
        if (this.isStarted) {
            return;
        }
        this.structureName = null;
        this.buildResources.clear();
        this.remainingTime = 0;
        StructureTemplateManager.getTemplate(templateName).ifPresent(t -> {
            if (t.getValidationSettings().isSurvival()) {
                this.structureName = templateName;
            }
            t.getResourceList().forEach(buildResource -> this.buildResources.add(buildResource.copy()));
            this.calcTime();
        });
        this.func_70296_d();
    }

    private void calcTime() {
        int count = 0;
        for (StructureTemplate.BuildResource resource : this.buildResources) {
            count += resource.getStackRequired().func_190916_E();
        }
        this.totalTime = this.remainingTime = count;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputSlots.deserializeNBT(tag.func_74775_l("inputInventory"));
        this.outputSlot.deserializeNBT(tag.func_74775_l("outputInventory"));
        this.structureName = tag.func_74764_b(STRUCTURE_NAME_TAG) ? tag.func_74779_i(STRUCTURE_NAME_TAG) : null;
        this.isStarted = tag.func_74767_n("isStarted");
        this.isFinished = tag.func_74767_n("isFinished");
        this.remainingTime = tag.func_74762_e("remainingTime");
        this.totalTime = tag.func_74762_e("totalTime");
        this.buildResources = NBTHelper.deserializeListFrom(tag, "buildResources", StructureTemplate.BuildResource::new);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inputInventory", (NBTBase)this.inputSlots.serializeNBT());
        tag.func_74782_a("outputInventory", (NBTBase)this.outputSlot.serializeNBT());
        if (this.structureName != null) {
            tag.func_74778_a(STRUCTURE_NAME_TAG, this.structureName);
        }
        tag.func_74757_a("isStarted", this.isStarted);
        tag.func_74757_a("isFinished", this.isFinished);
        tag.func_74768_a("remainingTime", this.remainingTime);
        tag.func_74768_a("totalTime", this.totalTime);
        NBTHelper.writeSerializablesTo(tag, "buildResources", this.buildResources);
        return tag;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.inputSlots, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.outputSlot, this.field_174879_c);
    }
}

