/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;
import net.shadowmage.ancientwarfare.structure.util.LootHelper;

public class TileGravestone
extends TileUpdatable
implements ISpecialLootContainer,
IBlockBreakHandler,
BlockRotationHandler.IRotatableTile {
    private EnumFacing facing = EnumFacing.NORTH;
    private int variant = 1;
    private LootSettings lootSettings = new LootSettings();

    @Override
    public EnumFacing getPrimaryFacing() {
        return this.facing;
    }

    @Override
    public void setPrimaryFacing(EnumFacing face) {
        this.facing = face;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    @Override
    public void setLootSettings(LootSettings settings) {
        this.lootSettings = settings;
    }

    @Override
    public LootSettings getLootSettings() {
        return this.lootSettings;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        LootHelper.dropLoot(this, EntityTools.findClosestPlayer(this.field_145850_b, this.field_174879_c, 100));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
        this.func_70296_d();
    }

    private void readNBT(NBTTagCompound compound) {
        this.variant = compound.func_74762_e("variant");
        this.lootSettings = LootSettings.deserializeNBT(compound.func_74775_l("lootSettings"));
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.writeNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.writeNBT(compound);
        return compound;
    }

    private NBTTagCompound writeNBT(NBTTagCompound compound) {
        compound.func_74782_a("lootSettings", (NBTBase)this.lootSettings.serializeNBT());
        compound.func_74768_a("variant", this.variant);
        return compound;
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        this.readNBT(tag);
        BlockTools.notifyBlockUpdate(this);
    }

    public void activate(EntityPlayer player) {
        if (6 <= this.getVariant() && this.getVariant() <= 8) {
            this.dropLoot(player);
        }
    }

    private void dropLoot(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            LootHelper.dropLoot(this, player);
        }
    }
}

