/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureEntry;
import net.shadowmage.ancientwarfare.structure.tile.TileFlag;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;
import net.shadowmage.ancientwarfare.structure.util.ConquerHelper;

public class TileProtectionFlag
extends TileFlag {
    private static final String PLAYER_PROFILE_TAG = "playerProfile";
    private static final String OWNER_TAG = "owner";
    private static final float UNBREAKABLE = -1.0f;
    private Owner owner = Owner.EMPTY;
    private GameProfile playerProfile;

    @Override
    protected void readNBT(NBTTagCompound tag) {
        super.readNBT(tag);
        if (tag.func_74764_b(OWNER_TAG)) {
            this.owner = Owner.deserializeFromNBT(tag.func_74775_l(OWNER_TAG));
            this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l(PLAYER_PROFILE_TAG));
        }
    }

    @Override
    protected NBTTagCompound writeNBT(NBTTagCompound tag) {
        super.writeNBT(tag);
        if (this.owner != Owner.EMPTY) {
            tag.func_74782_a(OWNER_TAG, (NBTBase)this.owner.serializeToNBT(new NBTTagCompound()));
            tag.func_74782_a(PLAYER_PROFILE_TAG, (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.playerProfile));
        }
        return tag;
    }

    public void func_145829_t() {
        super.func_145829_t();
        AWGameData.INSTANCE.getPerWorldData(this.field_145850_b, StructureMap.class).getStructureAt(this.field_145850_b, this.field_174879_c).ifPresent(structure -> {
            if (!structure.getProtectionFlagPos().equals((Object)this.field_174879_c)) {
                structure.setProtectionFlagPos(this.field_174879_c);
                if (!this.field_145850_b.field_72995_K) {
                    NetworkHandler.sendToAllPlayers(new PacketStructureEntry(this.field_145850_b.field_73011_w.getDimension(), structure.getChunkX(), structure.getChunkZ(), (StructureEntry)structure));
                }
            }
        });
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((Block)AWStructureBlocks.PROTECTION_FLAG);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNBT(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    public void onActivatedBy(EntityPlayer player) {
        if (this.isPlayerOwned() || this.field_145850_b.field_72995_K) {
            return;
        }
        Optional<StructureEntry> structure = AWGameData.INSTANCE.getPerWorldData(this.field_145850_b, StructureMap.class).getStructureAt(this.field_145850_b, this.field_174879_c);
        if (!structure.isPresent()) {
            return;
        }
        StructureEntry st = structure.get();
        if (ConquerHelper.checkBBConquered(player, st.getBB())) {
            this.turnOffSoundBlocks(st);
            this.setOwner(player, player.func_146103_bH());
            st.setConquered();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_conquered", new Object[]{st.getName()}), true);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, AWStructureSounds.PROTECTION_FLAG_CLAIM, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.func_70296_d();
        BlockTools.notifyBlockUpdate(this);
    }

    private void turnOffSoundBlocks(StructureEntry structure) {
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)structure.getBB().min, (BlockPos)structure.getBB().max)) {
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != AWStructureBlocks.SOUND_BLOCK) continue;
            WorldTools.getTile((IBlockAccess)this.field_145850_b, blockPos, TileSoundBlock.class).ifPresent(TileSoundBlock::turnOffByProtectionFlag);
        }
    }

    private void setOwner(EntityPlayer player, GameProfile playerProfile) {
        this.owner = new Owner(player);
        this.playerProfile = playerProfile;
    }

    @Override
    public boolean isPlayerOwned() {
        return this.owner != Owner.EMPTY;
    }

    @Override
    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, float original) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player) ? original : -1.0f;
    }

    public boolean shouldProtectAgainst(EntityPlayer player) {
        return !this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }
}

