/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.block.BlockStoneCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.tile.TileCoffin;

public class TileStoneCoffin
extends TileCoffin {
    private static final int TOTAL_OPEN_TIME = 60;
    private BlockStoneCoffin.Variant variant = BlockStoneCoffin.Variant.STONE;
    private static final Map<BlockCoffin.IVariant, SoundEvent> COFFIN_SOUNDS = ImmutableMap.of((Object)BlockStoneCoffin.Variant.STONE, (Object)AWStructureSounds.STONE_COFFIN_OPENS, (Object)BlockStoneCoffin.Variant.SANDSTONE, (Object)AWStructureSounds.SANDSTONE_SARCOPHAGUS_OPENS, (Object)BlockStoneCoffin.Variant.PRISMARINE, (Object)AWStructureSounds.PRISMARINE_COFFIN_OPENS, (Object)BlockStoneCoffin.Variant.DEMONIC, (Object)AWStructureSounds.DEMONIC_COFFIN_OPENS);

    public void setVariant(BlockStoneCoffin.Variant variant) {
        this.variant = variant;
    }

    @Override
    public BlockStoneCoffin.Variant getVariant() {
        return this.getValueFromMain(TileStoneCoffin.class, TileStoneCoffin::getVariant, this.variant, () -> BlockStoneCoffin.Variant.STONE);
    }

    @Override
    public Set<BlockPos> getAdditionalPositions(IBlockState state) {
        return ImmutableSet.of((Object)this.field_174879_c.func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing().func_176735_f()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing().func_176735_f()).func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing().func_176735_f()).func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()), (Object[])new BlockPos[]{this.field_174879_c.func_177972_a(this.direction.getFacing().func_176735_f()).func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing())});
    }

    @Override
    protected void playSound() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, COFFIN_SOUNDS.get(this.variant), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    protected int getTotalOpenTime() {
        return 60;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Vec3i vec = this.direction.getFacing().func_176730_m();
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-3, 0, -3), this.field_174879_c.func_177982_a(3, 2, 3)).func_72321_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
    }

    @Override
    protected void readNBT(NBTTagCompound compound) {
        super.readNBT(compound);
        this.variant = BlockStoneCoffin.Variant.fromName(compound.func_74779_i("variant"));
    }

    @Override
    protected void writeNBT(NBTTagCompound compound) {
        super.writeNBT(compound);
        compound.func_74778_a("variant", this.variant.func_176610_l());
    }
}

