/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderTicked;

public class TileStructureBuilder
extends TileUpdatable
implements IWorkSite,
IOwnable,
ITickable {
    private static final String BUILDER_TAG = "builder";
    private static final String BB_MIN_TAG = "bbMin";
    private static final String BB_MAX_TAG = "bbMax";
    private Owner owner = Owner.EMPTY;
    private StructureBuilderTicked builder;
    private boolean shouldRemove = false;
    private boolean isStarted = false;
    private int workDelay = 20;
    private double maxEnergyStored = AWCoreStatics.energyPerWorkUnit * 3.0;
    private double maxInput = AWCoreStatics.energyPerWorkUnit;
    private double storedEnergy;
    public StructureBB clientBB;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.clientBB != null ? new AxisAlignedBB(this.clientBB.min, this.clientBB.max) : super.getRenderBoundingBox();
    }

    @Override
    public Set<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        return 0.0f;
    }

    @Override
    public boolean useOutputRotation(@Nullable EnumFacing from) {
        return false;
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        if (this.canInputTorque(from)) {
            if (energy + this.getTorqueStored(null) > this.getMaxTorque(null)) {
                energy = this.getMaxTorque(null) - this.getTorqueStored(null);
            }
            if (energy > this.getMaxTorqueInput(null)) {
                energy = this.getMaxTorqueInput(null);
            }
            this.storedEnergy += energy;
            return energy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        return this.maxEnergyStored;
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        return this.storedEnergy;
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        return this.maxInput;
    }

    @Override
    public boolean canInputTorque(@Nullable EnumFacing from) {
        return true;
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.shouldRemove || this.builder == null || this.builder.invalid || this.builder.isFinished()) {
            this.shouldRemove = true;
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return;
        }
        if (this.builder.getWorld() == null) {
            this.builder.setWorld(this.field_145850_b);
        }
        if (Loader.isModLoaded((String)"ancientwarfareautomation") || Loader.isModLoaded((String)"ancientwarfarenpc")) {
            if (this.storedEnergy >= AWCoreStatics.energyPerWorkUnit) {
                this.storedEnergy -= AWCoreStatics.energyPerWorkUnit;
                this.processWork();
            }
        } else if (this.workDelay-- <= 0) {
            this.processWork();
            this.workDelay = 20;
        }
    }

    private void processWork() {
        this.isStarted = true;
        this.builder.tick();
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    public void setBuilder(StructureBuilderTicked builder) {
        this.builder = builder;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
    }

    public void onBlockClicked(EntityPlayer player) {
        if (this.builder.hasClearedArea()) {
            int pass = this.builder.getPass() + 1;
            int max = this.builder.getMaxPasses();
            float percent = this.builder.getPercentDoneWithPass() * 100.0f;
            String perc = String.format("%.2f", Float.valueOf(percent)) + "%";
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.builder.state", new Object[]{perc, pass, max}));
        } else {
            float percent = this.builder.getPercentDoneClearing() * 100.0f;
            String perc = String.format("%.2f", Float.valueOf(percent)) + "%";
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.builder.clear_state", new Object[]{perc}));
        }
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        if (this.builder == null) {
            return;
        }
        StructureBB bb = this.builder.getBoundingBox();
        tag.func_74772_a(BB_MIN_TAG, bb.min.func_177986_g());
        tag.func_74772_a(BB_MAX_TAG, bb.max.func_177986_g());
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        if (tag.func_74764_b(BB_MIN_TAG) && tag.func_74764_b(BB_MAX_TAG)) {
            this.clientBB = new StructureBB(BlockPos.func_177969_a((long)tag.func_74763_f(BB_MIN_TAG)), BlockPos.func_177969_a((long)tag.func_74763_f(BB_MAX_TAG)));
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(BUILDER_TAG)) {
            this.builder = new StructureBuilderTicked();
            this.builder.readFromNBT(tag.func_74775_l(BUILDER_TAG));
        } else {
            this.shouldRemove = true;
        }
        this.isStarted = tag.func_74767_n("started");
        this.storedEnergy = tag.func_74769_h("storedEnergy");
        this.owner = Owner.deserializeFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.builder != null) {
            NBTTagCompound builderTag = new NBTTagCompound();
            this.builder.writeToNBT(builderTag);
            tag.func_74782_a(BUILDER_TAG, (NBTBase)builderTag);
        }
        tag.func_74757_a("started", this.isStarted);
        tag.func_74780_a("storedEnergy", this.storedEnergy);
        this.owner.serializeToNBT(tag);
        return tag;
    }

    @Override
    public boolean hasWork() {
        return this.storedEnergy < this.maxEnergyStored;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public final Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.owner.getName());
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType());
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit;
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        return 0.0;
    }

    @Override
    public boolean canOutputTorque(EnumFacing towards) {
        return false;
    }

    @Override
    public double drainTorque(EnumFacing from, double energy) {
        return 0.0;
    }

    public StructureBuilderTicked getBuilder() {
        return this.builder;
    }
}

