/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.block.BlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.tile.TileCoffin;

public class TileWoodenCoffin
extends TileCoffin {
    private static final int TOTAL_OPEN_TIME = 20;
    private BlockWoodenCoffin.Variant variant = BlockWoodenCoffin.Variant.OAK;
    private boolean upright = false;

    @Override
    protected int getTotalOpenTime() {
        return 20;
    }

    @Override
    public Set<BlockPos> getAdditionalPositions(IBlockState state) {
        return this.upright ? ImmutableSet.of((Object)this.field_174879_c.func_177984_a(), (Object)this.field_174879_c.func_177984_a().func_177984_a()) : ImmutableSet.of((Object)this.field_174879_c.func_177972_a(this.direction.getFacing()), (Object)this.field_174879_c.func_177972_a(this.direction.getFacing()).func_177972_a(this.direction.getFacing()));
    }

    public void setVariant(BlockWoodenCoffin.Variant variant) {
        this.variant = variant;
    }

    @Override
    public BlockWoodenCoffin.Variant getVariant() {
        return this.getValueFromMain(TileWoodenCoffin.class, TileWoodenCoffin::getVariant, this.variant, () -> BlockWoodenCoffin.Variant.OAK);
    }

    @Override
    public void setPlacementDirection(World world, BlockPos pos, IBlockState state, EnumFacing horizontalFacing, float rotationYaw) {
        this.setDirection(this.upright ? BlockCoffin.CoffinDirection.fromYaw(rotationYaw) : BlockCoffin.CoffinDirection.fromFacing(horizontalFacing));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.upright) {
            return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 3, 2));
        }
        Vec3i vec = this.direction.getFacing().func_176730_m();
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 1, 2)).func_72321_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
    }

    @Override
    protected void readNBT(NBTTagCompound compound) {
        super.readNBT(compound);
        this.upright = compound.func_74767_n("upright");
        this.variant = BlockWoodenCoffin.Variant.fromName(compound.func_74779_i("variant"));
    }

    @Override
    protected void writeNBT(NBTTagCompound compound) {
        super.writeNBT(compound);
        compound.func_74757_a("upright", this.upright);
        compound.func_74778_a("variant", this.variant.func_176610_l());
    }

    @Override
    protected void playSound() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, AWStructureSounds.COFFIN_OPENS, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void setUpright(boolean upright) {
        this.upright = upright;
    }

    public boolean getUpright() {
        return this.upright;
    }
}

