/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.Optional;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.shadowmage.ancientwarfare.automation.registry.TreeFarmRegistry;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITreeScanner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.SmoothingMatrixBuilder;

public class TownGeneratorBorders {
    private static final int CLEAR_TREE_MAX_BORDER_DISTANCE = 10;
    public static final int MAX_BORDER_WIDTH = 20;

    private TownGeneratorBorders() {
    }

    public static void generateBorders(World world, StructureBB exterior) {
        BlockTools.getAllInBoxTopDown(exterior.min, exterior.max.func_177982_a(0, 50, 0)).forEach(pos -> TownGeneratorBorders.handleClearing(world, pos));
        new SmoothingMatrixBuilder(world, exterior, Math.min(Math.max(exterior.getXSize(), exterior.getZSize()) / 8, 20), exterior.min.func_177956_o() - 1, p -> world.func_180494_b((BlockPos)p).field_76752_A).build().apply(world, pos -> TownGeneratorBorders.handleClearing(world, pos));
    }

    public static void levelTownArea(World world, StructureBB bb) {
        int minX = bb.min.func_177958_n();
        int minZ = bb.min.func_177952_p();
        int maxX = bb.max.func_177958_n();
        int maxZ = bb.max.func_177952_p();
        int desiredTopBlockHeight = bb.min.func_177956_o() - 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                TownGeneratorBorders.handleBorderBlock(world, x, z, desiredTopBlockHeight, desiredTopBlockHeight, TownGeneratorBorders.getFillBlock(world, x, z, false), TownGeneratorBorders.getFillBlock(world, x, z, true));
                world.func_175656_a(new BlockPos(x, desiredTopBlockHeight - 5, z), Blocks.field_150347_e.func_176223_P());
            }
        }
    }

    private static void handleBorderBlock(World world, int x, int z, int fillLevel, int cutLevel, IBlockState fillBlock, IBlockState topBlock) {
        int py;
        int y = BlockTools.getTopFilledHeight(world.func_175726_f(new BlockPos(x, 1, z)), x, z, false);
        int topSolidY = BlockTools.getTopFilledHeight(world.func_175726_f(new BlockPos(x, 1, z)), x, z, true);
        if (y >= cutLevel) {
            for (py = y; py > Math.min(topSolidY, cutLevel); --py) {
                BlockPos clearPos = new BlockPos(x, py, z);
                TownGeneratorBorders.handleClearing(world, clearPos);
            }
            if (topSolidY > cutLevel) {
                world.func_175656_a(new BlockPos(x, cutLevel, z), topBlock);
            }
        }
        if (topSolidY <= fillLevel) {
            for (py = topSolidY + 1; py < fillLevel; ++py) {
                world.func_175656_a(new BlockPos(x, py, z), fillBlock);
            }
            world.func_175656_a(new BlockPos(x, fillLevel, z), topBlock);
        }
    }

    private static void handleClearing(World world, BlockPos clearPos) {
        IBlockState state = world.func_180495_p(clearPos);
        if (state.func_185904_a() != Material.field_151579_a) {
            Optional<ITreeScanner> treeScanner = TreeFarmRegistry.getRegisteredTreeScanner(state);
            if (!treeScanner.isPresent()) {
                world.func_175698_g(clearPos);
                return;
            }
            ITree tree = treeScanner.get().scanTree(world, clearPos, clearPos.func_177982_a(-10, 0, -10), clearPos.func_177982_a(10, 0, 10));
            tree.getLeafPositions().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
            tree.getTrunkPositions().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
    }

    private static IBlockState getFillBlock(World world, int x, int z, boolean surface) {
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        if (surface) {
            return biome.field_76752_A;
        }
        return biome.field_76753_B;
    }
}

