/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;
import net.shadowmage.ancientwarfare.structure.town.TownPartPlot;
import net.shadowmage.ancientwarfare.structure.town.TownPartQuadrant;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

class TownGeneratorStructures {
    private TownGeneratorStructures() {
    }

    static void generateStructures(final TownGenerator gen) {
        final ArrayList<TownPartBlock> blocks = new ArrayList<TownPartBlock>();
        for (TownPartQuadrant tq : gen.quadrants) {
            tq.addBlocks(blocks);
        }
        blocks.sort(new TownPartBlockComparator());
        TownGeneratorStructures.generateUniques(blocks, gen.uniqueTemplatesToGenerate, gen);
        TownGeneratorStructures.generateMains(blocks, gen.mainTemplatesToGenerate, gen);
        TownGeneratorStructures.generateHouses(blocks, gen.houseTemplatesToGenerate, gen);
        TownGeneratorStructures.generateCosmetics(blocks, gen.cosmeticTemplatesToGenerate, gen);
        if (gen.template.getExteriorSize() > 0) {
            ArrayList<TownPartBlock> exteriorBlocks = new ArrayList<TownPartBlock>();
            for (TownPartQuadrant tq : gen.externalQuadrants) {
                tq.addBlocks(exteriorBlocks);
            }
            TownGeneratorStructures.generateExteriorStructures(exteriorBlocks, gen.exteriorTemplatesToGenerate, gen);
            blocks.addAll(exteriorBlocks);
        }
        WorldGenTickHandler.INSTANCE.addStructureGenCallback(new WorldGenTickHandler.StructureTicket(){

            @Override
            public void call() {
                gen.template.getLamp().ifPresent(lamp -> TownGeneratorStructures.generateLamps(blocks, lamp, gen));
                WorldStructureGenerator.sprinkleSnow(gen.world, gen.maximalBounds, 0);
                gen.generateVillagers();
            }

            @Override
            public int getBlocksToGenerate() {
                return 100;
            }
        });
    }

    private static void generateUniques(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < templatesToGenerate.size(); ++i) {
            indexes.add(i);
        }
        for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (indexes.isEmpty()) {
                    return;
                }
                int idx = gen.rng.nextInt(indexes.size());
                if (TownGeneratorStructures.generateStructureForPlot(gen, plot, templatesToGenerate.get((Integer)indexes.get(idx)), false)) {
                    return;
                }
                indexes.remove(idx);
            }
        }
    }

    private static void generateMains(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (templatesToGenerate.isEmpty()) {
                    return;
                }
                if (!TownGeneratorStructures.generateStructureForPlot(gen, plot, templatesToGenerate.get(0), false)) continue;
                templatesToGenerate.remove(0);
            }
        }
    }

    private static void generateHouses(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        if (templatesToGenerate.isEmpty()) {
            return;
        }
        for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (gen.template.getInteriorEmtpyPlotChance() > 0 && gen.rng.nextInt(100) < gen.template.getInteriorEmtpyPlotChance()) {
                    plot.skipped = true;
                    continue;
                }
                TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.nonRepeatingRng).ifPresent(template -> TownGeneratorStructures.generateStructureForPlot(gen, plot, template, false));
            }
        }
    }

    private static void generateCosmetics(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || plot.skipped) continue;
                if (templatesToGenerate.isEmpty()) {
                    return;
                }
                TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.nonRepeatingRng).ifPresent(template -> TownGeneratorStructures.generateStructureForPlot(gen, plot, template, true));
            }
        }
    }

    private static void generateExteriorStructures(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        float l1 = (float)gen.exteriorBounds.getXSize() / 2.0f;
        float l2 = (float)gen.exteriorBounds.getZSize() / 2.0f;
        float maxDistance = Trig.getDistance(l1, 0.0, l2, 0.0, 0.0, 0.0);
        l1 = (float)gen.wallsBounds.getXSize() / 2.0f;
        l2 = (float)gen.wallsBounds.getZSize() / 2.0f;
        float minDistance = Math.min(l1, l2);
        float minMaxDelta = maxDistance - minDistance;
        for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed) continue;
                if (templatesToGenerate.isEmpty()) {
                    return;
                }
                float plotDistance = Trig.getDistance(plot.bb.getCenterX(), 0.0, plot.bb.getCenterZ(), gen.maximalBounds.getCenterX(), 0.0, gen.maximalBounds.getCenterZ()) - minDistance;
                float distPercent = plotDistance / minMaxDelta;
                distPercent = 1.0f - distPercent;
                distPercent *= distPercent;
                if (!(gen.rng.nextFloat() < distPercent)) continue;
                TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.nonRepeatingRng).ifPresent(template -> TownGeneratorStructures.generateStructureForPlot(gen, plot, template, true));
            }
        }
    }

    private static void generateLamps(List<TownPartBlock> blocks, TownTemplate.TownStructureEntry templateToGenerate, TownGenerator gen) {
        StructureTemplateManager.getTemplate(templateToGenerate.templateName).ifPresent(lamp -> {
            for (TownPartBlock block : blocks) {
                TownGeneratorStructures.generateLamps(gen.world, block, lamp, gen.structureDoors);
            }
        });
    }

    private static void generateLamps(World world, TownPartBlock block, StructureTemplate lamp, List<BlockPos> doors) {
        int z;
        int zBit;
        int x;
        int xBit;
        int zMove;
        int zStart;
        int xMove;
        int xStart;
        Direction xDir = block.quadrant.getXDir();
        Direction zDir = block.quadrant.getZDir();
        int lampSize = Math.max(lamp.getSize().func_177958_n(), lamp.getSize().func_177952_p());
        int size = 5 + lampSize;
        int xBits = (block.bb.getXSize() - lampSize) / size;
        int zBits = (block.bb.getZSize() - lampSize) / size;
        if (block.bb.getXSize() % size == size - 1) {
            --xBits;
        }
        if (block.bb.getZSize() % size == size - 1) {
            --zBits;
        }
        int lampOffset = lampSize / 2;
        if (xDir == Direction.WEST) {
            xStart = block.bb.max.func_177958_n() - lampOffset;
            xMove = -size;
        } else {
            xStart = block.bb.min.func_177958_n() + lampOffset;
            xMove = size;
        }
        if (zDir == Direction.NORTH) {
            zStart = block.bb.max.func_177952_p() - lampOffset;
            zMove = -size;
        } else {
            zStart = block.bb.min.func_177952_p() + lampOffset;
            zMove = size;
        }
        if (block.hasRoadBorder(Direction.NORTH)) {
            for (xBit = 0; xBit <= xBits; ++xBit) {
                x = xBit * xMove + xStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, x, block.bb.min.func_177956_o(), block.bb.min.func_177952_p() + lampOffset, Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.SOUTH)) {
            for (xBit = 0; xBit <= xBits; ++xBit) {
                x = xBit * xMove + xStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, x, block.bb.min.func_177956_o(), block.bb.max.func_177952_p() - lampOffset, Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.WEST)) {
            for (zBit = 0; zBit <= zBits; ++zBit) {
                z = zBit * zMove + zStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, block.bb.min.func_177958_n() + lampOffset, block.bb.min.func_177956_o(), z, Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.EAST)) {
            for (zBit = 0; zBit <= zBits; ++zBit) {
                z = zBit * zMove + zStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, block.bb.max.func_177958_n() - lampOffset, block.bb.min.func_177956_o(), z, Direction.EAST);
            }
        }
    }

    private static void generateLamp(World world, StructureTemplate template, List<BlockPos> doors, int x, int y, int z, Direction streetSide) {
        if (TownGeneratorStructures.checkForNeighboringDoor(doors, x, z, streetSide.getOpposite())) {
            return;
        }
        x += template.getSize().func_177958_n() / 2;
        z += template.getSize().func_177952_p() / 2;
        BlockPos pos = new BlockPos(x -= template.getOffset().func_177958_n(), y, z -= template.getOffset().func_177952_p());
        StructureBB bb = new StructureBB(pos, EnumFacing.SOUTH, template);
        for (BlockPos posToCheck : BlockPos.func_177980_a((BlockPos)bb.min.func_177982_a(0, template.getOffset().func_177956_o(), 0), (BlockPos)bb.max)) {
            if (world.func_175623_d(posToCheck)) continue;
            return;
        }
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(world, template, EnumFacing.SOUTH, pos));
    }

    private static boolean checkForNeighboringDoor(List<BlockPos> doors, int x, int z, Direction dir) {
        int x1 = x + dir.xDirection;
        int z1 = z + dir.zDirection;
        for (BlockPos p : doors) {
            if ((p.func_177958_n() != x || p.func_177952_p() != z) && (p.func_177958_n() != x1 || p.func_177952_p() != z1)) continue;
            return true;
        }
        return false;
    }

    private static boolean generateStructureForPlot(TownGenerator gen, TownPartPlot plot, StructureTemplate template, boolean centerLength) {
        int length;
        int expansion = gen.template.getTownBuildingWidthExpansion();
        EnumFacing face = EnumFacing.field_176754_o[gen.rng.nextInt(4)];
        for (int i = 0; i < 4 && !plot.roadBorders[(face = face.func_176746_e()).func_176736_b()]; ++i) {
        }
        int width = (face = face.func_176734_d()).func_176740_k() == EnumFacing.Axis.Z ? template.getSize().func_177958_n() : template.getSize().func_177952_p();
        int n = length = face.func_176740_k() == EnumFacing.Axis.Z ? template.getSize().func_177952_p() : template.getSize().func_177958_n();
        if (face == EnumFacing.SOUTH || face == EnumFacing.NORTH) {
            width += expansion;
        } else {
            length += expansion;
        }
        if (!(plot.getWidth() >= width && plot.getLength() >= length || plot.expand(width, length))) {
            return false;
        }
        plot.markClosed();
        if (face == EnumFacing.SOUTH || face == EnumFacing.NORTH) {
            width -= expansion;
        } else {
            length -= expansion;
        }
        TownGeneratorStructures.generateStructure(gen, plot, template, face, width, length, centerLength);
        return true;
    }

    private static void generateStructure(TownGenerator gen, TownPartPlot plot, StructureTemplate template, EnumFacing face, int width, int length, boolean center) {
        int lAdj;
        int wAdj;
        int plotWidth = plot.getWidth();
        int plotLength = plot.getLength();
        int extraWidth = plotWidth - width;
        int extraLength = plotLength - length;
        if (center) {
            wAdj = extraWidth / 2;
            lAdj = extraLength / 2;
        } else {
            if (face.func_176740_k() == EnumFacing.Axis.Z) {
                wAdj = extraWidth / 2;
            } else {
                int n = wAdj = face == EnumFacing.WEST ? extraWidth : 0;
            }
            lAdj = face.func_176740_k() == EnumFacing.Axis.X ? extraLength / 2 : (face == EnumFacing.NORTH ? extraLength : 0);
        }
        BlockPos min = new BlockPos(plot.bb.min.func_177958_n() + wAdj, gen.townBounds.min.func_177956_o(), plot.bb.min.func_177952_p() + lAdj);
        BlockPos max = new BlockPos(min.func_177958_n() + (width - 1), min.func_177956_o() + template.getSize().func_177956_o(), min.func_177952_p() + (length - 1));
        StructureBB bb = new StructureBB(min, max);
        BlockPos buildKey = bb.getRLCorner(face, BlockPos.field_177992_a).func_177967_a(face.func_176746_e(), template.getOffset().func_177958_n()).func_177967_a(face.func_176734_d(), template.getOffset().func_177952_p()).func_177981_b(gen.townBounds.min.func_177956_o() - template.getOffset().func_177956_o());
        bb.add(0, -template.getOffset().func_177956_o(), 0);
        gen.structureDoors.add(buildKey);
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(gen.world, template, face, buildKey, bb));
    }

    private static Optional<StructureTemplate> getRandomTemplate(List<StructureTemplate> templatesToGenerate, Random rng) {
        if (templatesToGenerate.isEmpty()) {
            return Optional.empty();
        }
        int roll = rng.nextInt(templatesToGenerate.size());
        return Optional.of(templatesToGenerate.get(roll));
    }

    public static class TownPartBlockComparator
    implements Comparator<TownPartBlock> {
        @Override
        public int compare(TownPartBlock o1, TownPartBlock o2) {
            if (o1.distFromTownCenter < o2.distFromTownCenter) {
                return -1;
            }
            if (o1.distFromTownCenter > o2.distFromTownCenter) {
                return 1;
            }
            return 0;
        }
    }
}

