/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.Optional;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;

public class TownGeneratorWalls {
    private TownGeneratorWalls() {
    }

    public static void generateWalls(World world, TownGenerator gen, TownTemplate template, Random rng) {
        if (template.getWallStyle() <= 0) {
            return;
        }
        int minX = gen.wallsBounds.min.func_177958_n();
        int minZ = gen.wallsBounds.min.func_177952_p();
        int maxX = gen.wallsBounds.max.func_177958_n();
        int maxZ = gen.wallsBounds.max.func_177952_p();
        int minY = gen.wallsBounds.min.func_177956_o();
        TownGeneratorWalls.getCornerSection(rng, template).ifPresent(corner -> TownGeneratorWalls.constructTemplate(world, corner, EnumFacing.SOUTH, new BlockPos(minX, minY, minZ)));
        TownGeneratorWalls.getCornerSection(rng, template).ifPresent(corner -> TownGeneratorWalls.constructTemplate(world, corner, EnumFacing.WEST, new BlockPos(maxX, minY, minZ)));
        TownGeneratorWalls.getCornerSection(rng, template).ifPresent(corner -> TownGeneratorWalls.constructTemplate(world, corner, EnumFacing.NORTH, new BlockPos(maxX, minY, maxZ)));
        TownGeneratorWalls.getCornerSection(rng, template).ifPresent(corner -> TownGeneratorWalls.constructTemplate(world, corner, EnumFacing.EAST, new BlockPos(minX, minY, maxZ)));
        if (template.getWallStyle() > 1) {
            int z;
            int x;
            int i;
            int chunkWidth = (maxX - minX + 1) / 16;
            int chunkLength = (maxZ - minZ + 1) / 16;
            for (i = 1; i < chunkWidth - 1; ++i) {
                x = minX + 16 * i;
                TownGeneratorWalls.getWallSection(rng, template, i, chunkWidth).ifPresent(wall -> TownGeneratorWalls.constructTemplate(world, wall, EnumFacing.SOUTH, new BlockPos(x, minY, minZ)));
            }
            for (i = 1; i < chunkLength - 1; ++i) {
                z = minZ + 16 * i;
                TownGeneratorWalls.getWallSection(rng, template, i, chunkLength).ifPresent(wall -> TownGeneratorWalls.constructTemplate(world, wall, EnumFacing.WEST, new BlockPos(maxX, minY, z)));
            }
            for (i = 1; i < chunkWidth - 1; ++i) {
                x = maxX - 16 * i;
                TownGeneratorWalls.getWallSection(rng, template, i, chunkWidth).ifPresent(wall -> TownGeneratorWalls.constructTemplate(world, wall, EnumFacing.NORTH, new BlockPos(x, minY, maxZ)));
            }
            for (i = 1; i < chunkLength - 1; ++i) {
                z = maxZ - 16 * i;
                TownGeneratorWalls.getWallSection(rng, template, i, chunkLength).ifPresent(wall -> TownGeneratorWalls.constructTemplate(world, wall, EnumFacing.EAST, new BlockPos(minX, minY, z)));
            }
        }
    }

    private static Optional<StructureTemplate> getWallSection(Random rng, TownTemplate template, int index, int wallLength) {
        TownTemplate.TownWallEntry entry;
        int[] pattern;
        if (template.getWallStyle() == 2) {
            if (wallLength % 2 == 0) {
                int middle = wallLength / 2;
                if (index == middle) {
                    return StructureTemplateManager.getTemplate(template.getRandomWeightedGateLeft(rng));
                }
                if (index == middle - 1) {
                    return StructureTemplateManager.getTemplate(template.getRandomWeightedGateRight(rng));
                }
                return StructureTemplateManager.getTemplate(template.getRandomWeightedWall(rng));
            }
            int middle = wallLength / 2;
            if (index == middle) {
                return StructureTemplateManager.getTemplate(template.getRandomWeightedGate(rng));
            }
            return StructureTemplateManager.getTemplate(template.getRandomWeightedWall(rng));
        }
        if (template.getWallStyle() == 3 && (pattern = template.getWallPattern(wallLength)) != null && wallLength <= pattern.length && (entry = template.getWall(template.getWallPattern(wallLength)[index])) != null) {
            return StructureTemplateManager.getTemplate(entry.templateName);
        }
        return Optional.empty();
    }

    private static Optional<StructureTemplate> getCornerSection(Random rng, TownTemplate template) {
        return StructureTemplateManager.getTemplate(template.getRandomWeightedCorner(rng));
    }

    private static void constructTemplate(World world, StructureTemplate template, EnumFacing face, BlockPos pos) {
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(world, template, face, pos.func_177967_a(face.func_176735_f(), 15 - template.getOffset().func_177958_n())));
    }
}

