/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;

public class TownPartQuadrant {
    protected StructureBB bb;
    public final TownGenerator gen;
    private Direction xDir;
    private Direction zDir;
    protected int xDivs;
    protected int zDivs;
    private boolean[] roadBorders;
    protected TownPartBlock[] blocks;

    public TownPartQuadrant(Direction xDir, Direction zDir, StructureBB bb, boolean[] borders, TownGenerator gen) {
        this.xDir = xDir;
        this.zDir = zDir;
        this.bb = bb;
        this.roadBorders = borders;
        this.gen = gen;
    }

    public boolean hasRoadBorder(Direction d) {
        return this.roadBorders[d.ordinal()];
    }

    protected void setRoadBorder(Direction d, boolean val) {
        this.roadBorders[d.ordinal()] = val;
    }

    public void subdivide(int blockSize, int plotSize, boolean gridRoads) {
        int totalWidth = this.bb.max.func_177958_n() - this.bb.min.func_177958_n();
        int totalLength = this.bb.max.func_177952_p() - this.bb.min.func_177952_p();
        int widthToUse = totalWidth;
        int lengthToUse = totalLength;
        int y1 = this.gen.maximalBounds.min.func_177956_o();
        int y2 = this.gen.maximalBounds.max.func_177956_o();
        --widthToUse;
        --lengthToUse;
        while (widthToUse > 0) {
            widthToUse -= blockSize;
            widthToUse -= 2;
            ++this.xDivs;
        }
        while (lengthToUse > 0) {
            lengthToUse -= blockSize;
            lengthToUse -= 2;
            ++this.zDivs;
        }
        this.blocks = new TownPartBlock[this.xDivs * this.zDivs];
        float distFromTownCenter = 0.0f;
        widthToUse = totalWidth;
        int xStart = this.xDir.xDirection < 0 ? this.bb.max.func_177958_n() - 1 : this.bb.min.func_177958_n() + 1;
        for (int x = 0; x < this.xDivs; ++x) {
            int xSize = widthToUse > blockSize ? blockSize : widthToUse;
            int xEnd = xStart + this.xDir.xDirection * (xSize - 1);
            int xIndex = this.xDir == Direction.WEST ? this.xDivs - 1 - x : x;
            int zStart = this.zDir.zDirection < 0 ? this.bb.max.func_177952_p() - 1 : this.bb.min.func_177952_p() + 1;
            lengthToUse = this.bb.max.func_177952_p() - this.bb.min.func_177952_p();
            for (int z = 0; z < this.zDivs; ++z) {
                int zSize = lengthToUse > blockSize ? blockSize : lengthToUse;
                int zEnd = zStart + this.zDir.zDirection * (zSize - 1);
                int zIndex = this.zDir == Direction.NORTH ? this.zDivs - 1 - z : z;
                StructureBB sbb = new StructureBB(new BlockPos(xStart, y1, zStart), new BlockPos(xEnd, y2, zEnd));
                boolean[] borders = gridRoads ? this.getBordersGrid(xIndex, zIndex) : this.getBordersExterior(x, z);
                distFromTownCenter = Trig.getDistance(sbb.getCenterX(), y1, sbb.getCenterZ(), this.gen.maximalBounds.getCenterX(), y1, this.gen.maximalBounds.getCenterZ());
                TownPartBlock block = new TownPartBlock(this, sbb, xIndex, zIndex, borders, distFromTownCenter);
                this.setBlock(block, xIndex, zIndex);
                block.subdivide(plotSize);
                lengthToUse -= blockSize + 2;
                zStart = zEnd + this.zDir.zDirection * 3;
            }
            widthToUse -= blockSize + 2;
            xStart = xEnd + this.xDir.xDirection * 3;
        }
    }

    private void setBlock(TownPartBlock tb, int x, int z) {
        this.blocks[this.getIndex((int)x, (int)z)] = tb;
    }

    protected TownPartBlock getBlock(int x, int z) {
        return this.blocks[this.getIndex(x, z)];
    }

    private int getIndex(int x, int z) {
        return z * this.xDivs + x;
    }

    private boolean[] getBordersGrid(int x, int z) {
        boolean[] borders = new boolean[4];
        if (this.zDir == Direction.NORTH) {
            borders[Direction.SOUTH.ordinal()] = true;
            borders[Direction.NORTH.ordinal()] = z > 0;
        } else {
            borders[Direction.NORTH.ordinal()] = true;
            boolean bl = borders[Direction.SOUTH.ordinal()] = z < this.zDivs - 1;
        }
        if (this.xDir == Direction.WEST) {
            borders[Direction.EAST.ordinal()] = true;
            borders[Direction.WEST.ordinal()] = x > 0;
        } else {
            borders[Direction.WEST.ordinal()] = true;
            borders[Direction.EAST.ordinal()] = x < this.xDivs - 1;
        }
        return borders;
    }

    private boolean[] getBordersExterior(int x, int z) {
        boolean[] borders = new boolean[4];
        borders[Direction.WEST.ordinal()] = this.roadBorders[Direction.WEST.ordinal()] && x == 0;
        borders[Direction.EAST.ordinal()] = this.roadBorders[Direction.EAST.ordinal()] && x == 0;
        borders[Direction.NORTH.ordinal()] = this.roadBorders[Direction.NORTH.ordinal()] && z == 0;
        borders[Direction.SOUTH.ordinal()] = this.roadBorders[Direction.SOUTH.ordinal()] && z == 0;
        return borders;
    }

    public void addBlocks(List<TownPartBlock> blocks) {
        Collections.addAll(blocks, this.blocks);
    }

    public Direction getXDir() {
        return this.xDir;
    }

    public Direction getZDir() {
        return this.zDir;
    }
}

