/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;

public class TownTemplateManager {
    public static final TownTemplateManager INSTANCE = new TownTemplateManager();
    private final HashMap<String, TownTemplate> templates = new HashMap();
    private final List<TownTemplate> searchCache = new ArrayList<TownTemplate>();

    private TownTemplateManager() {
    }

    public void loadTemplate(TownTemplate template) {
        this.templates.put(template.getTownTypeName(), template);
    }

    public Optional<TownTemplate> getTemplate(String name) {
        return Optional.ofNullable(this.templates.get(name));
    }

    public Collection<TownTemplate> getTemplates() {
        return this.templates.values();
    }

    List<TownTemplate> getTemplatesValidAtPosition(World world, int x, int z) {
        if (world.field_73011_w == null) {
            AncientWarfareStructure.LOG.debug("World provider was null when trying to generate town");
            return Collections.emptyList();
        }
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        ResourceLocation rl = biome.getRegistryName();
        if (rl == null) {
            AncientWarfareStructure.LOG.debug("Biome based on class {} isn't registered and because of that Ancient Warfare can't process biome validation. This may be an error which may need to be fixed by the mod that added the biome.", biome.getClass());
            return Collections.emptyList();
        }
        String biomeName = rl.toString();
        return this.templates.values().stream().filter(t -> this.isDimensionValid(world.field_73011_w.getDimension(), (TownTemplate)t) && this.isBiomeValid(biomeName, (TownTemplate)t)).collect(Collectors.toList());
    }

    Optional<TownTemplate> selectTemplateFittingArea(World world, TownBoundingArea area, List<TownTemplate> templates, Territory territory) {
        TownTemplate selection = null;
        int width = area.getChunkWidth();
        int length = area.getChunkLength();
        int min = Math.min(width, length);
        int totalWeight = 0;
        for (TownTemplate t : templates) {
            int templateMinimumSize = t.getMinSize();
            if (min < templateMinimumSize || !this.isCorrectTerritory(territory.getTerritoryName(), t) || territory.getRemainingClusterValue() <= t.getClusterValue()) continue;
            this.searchCache.add(t);
            totalWeight += t.getSelectionWeight();
        }
        if (!this.searchCache.isEmpty() && totalWeight > 0) {
            totalWeight = world.field_73012_v.nextInt(totalWeight);
            for (TownTemplate t : this.searchCache) {
                if ((totalWeight -= t.getSelectionWeight()) >= 0) continue;
                selection = t;
                break;
            }
        }
        this.searchCache.clear();
        return Optional.ofNullable(selection);
    }

    private boolean isCorrectTerritory(String territoryName, TownTemplate t) {
        return t.getTerritoryName().equals(territoryName) || t.getTerritoryName().isEmpty();
    }

    private boolean isBiomeValid(String biome, TownTemplate t) {
        boolean contains = t.getBiomeList().contains(biome);
        boolean wl = t.isBiomeWhiteList();
        return wl && contains || !wl && !contains;
    }

    private boolean isDimensionValid(int dimension, TownTemplate t) {
        return t.getDimensionList().contains(dimension) == t.isDimensionWhiteList();
    }

    public void removeAll() {
        this.templates.clear();
    }
}

