/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPlacementValidator;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryManager;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;

public class WorldTownGenerator
implements IWorldGenerator {
    public static final WorldTownGenerator INSTANCE = new WorldTownGenerator();

    private WorldTownGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos cc = world.func_175694_M();
        double distSq = cc.func_177954_c((double)(chunkX * 16), (double)cc.func_177956_o(), (double)(chunkZ * 16));
        if (AWStructureStatics.withinProtectionRange(distSq)) {
            return;
        }
        if (random.nextFloat() < AWStructureStatics.townGenerationChance) {
            WorldGenTickHandler.INSTANCE.addChunkForTownGeneration(world, chunkX, chunkZ);
        }
    }

    public void attemptGeneration(World world, int blockX, int blockZ) {
        List<TownTemplate> templates = TownTemplateManager.INSTANCE.getTemplatesValidAtPosition(world, blockX, blockZ);
        if (templates.isEmpty()) {
            return;
        }
        TownPlacementValidator.findGenerationPosition(world, blockX, blockZ).ifPresent(area -> this.selectTerritoryTemplate(world, blockX, blockZ, templates, (TownBoundingArea)area));
    }

    private void selectTerritoryTemplate(World world, int blockX, int blockZ, List<TownTemplate> templates, TownBoundingArea area) {
        TerritoryManager.getTerritory(blockX >> 4, blockZ >> 4, world).ifPresent(territory -> this.selectTemplateAndShrinkToMax(world, templates, area, (Territory)territory));
    }

    private void selectTemplateAndShrinkToMax(World world, List<TownTemplate> templates, TownBoundingArea area, Territory territory) {
        TownTemplateManager.INSTANCE.selectTemplateFittingArea(world, area, templates, territory).ifPresent(template -> {
            if (area.getChunkWidth() - 1 > template.getMaxSize()) {
                area.chunkMaxX = area.chunkMinX + template.getMaxSize();
            }
            if (area.getChunkLength() - 1 > template.getMaxSize()) {
                area.chunkMaxZ = area.chunkMinZ + template.getMaxSize();
            }
            this.generate(world, area, (TownTemplate)template);
            territory.addClusterValue(template.getClusterValue());
        });
    }

    public void generate(World world, TownBoundingArea area, TownTemplate template) {
        StructureMap map = AWGameData.INSTANCE.getPerWorldData(world, StructureMap.class);
        StructureBB bb = new StructureBB(new BlockPos(area.getBlockMinX(), area.getMinY(), area.getBlockMinZ()), new BlockPos(area.getBlockMaxX(), area.getMaxY(), area.getBlockMaxZ()));
        StructureEntry entry = new StructureEntry(bb, template.getTownTypeName(), template.getClusterValue(), area.getCenterX() >> 4, area.getCenterZ() >> 4);
        map.setGeneratedAt(world, area.getCenterX(), area.getCenterZ(), entry, false);
        AWGameData.INSTANCE.getPerWorldData(world, TownMap.class).setGenerated(new TownEntry(bb, template.shouldPreventNaturalHostileSpawns()));
        new TownGenerator(world, area, template).generate();
    }
}

