/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Optional<T> getWeightedRandomElement(Random rng, Collection<T> collection, ToIntFunction<T> getElementWeight, WeightedRandomLogger<T> logger) {
        int totalWeight = 0;
        for (T t : collection) {
            totalWeight += getElementWeight.applyAsInt(t);
        }
        int rnd = rng.nextInt(totalWeight + 1);
        Object toReturn = null;
        for (T t : collection) {
            if ((rnd -= getElementWeight.applyAsInt(t)) > 0) continue;
            toReturn = t;
            break;
        }
        logger.log(totalWeight, toReturn);
        return Optional.ofNullable(toReturn);
    }

    public static interface WeightedRandomLogger<T> {
        public void log(int var1, @Nullable T var2);
    }
}

