/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.TextUtils;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.network.PacketHighlightBlock;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.util.BlockHighlightInfo;

public class ConquerHelper {
    private static final Cache<StructureBB, Boolean> STRUCTURE_BB_CONQUERED = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    private ConquerHelper() {
    }

    private static boolean checkBBConquered(World world, StructureBB bb) {
        return ConquerHelper.checkBBConquered(world, bb, npc -> {}, pos -> {});
    }

    public static boolean checkBBConquered(EntityPlayer player, StructureBB bb) {
        return ConquerHelper.checkBBConquered(player.func_130014_f_(), bb, npc -> ConquerHelper.markNpcAndMessagePlayer(player, npc), pos -> ConquerHelper.markSpawnerAndMessagePlayer(player, pos));
    }

    private static void markSpawnerAndMessagePlayer(EntityPlayer player, BlockPos pos) {
        NetworkHandler.sendToPlayer((EntityPlayerMP)player, new PacketHighlightBlock(new BlockHighlightInfo(pos, player.func_130014_f_().func_82737_E() + 200L)));
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_spawner_present", new Object[0]), true);
    }

    private static void markNpcAndMessagePlayer(EntityPlayer player, NpcFaction npc) {
        npc.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 200));
        player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarestructure.structure_hostile_alive", new Object[]{TextUtils.getSimpleBlockPosString(npc.func_180425_c())}), true);
    }

    private static boolean checkBBConquered(World world, StructureBB bb, Consumer<NpcFaction> onHostileNpcFound, Consumer<BlockPos> onHostileSpawnerFound) {
        AxisAlignedBB boundingBox = bb.getAABB();
        for (NpcFaction factionNpc : world.func_72872_a(NpcFaction.class, boundingBox)) {
            if (factionNpc.isPassive()) continue;
            onHostileNpcFound.accept(factionNpc);
            return false;
        }
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)bb.min, (BlockPos)bb.max)) {
            if (!world.func_175667_e(blockPos)) {
                return false;
            }
            if (world.func_180495_p(blockPos).func_177230_c() != AWStructureBlocks.ADVANCED_SPAWNER || !WorldTools.getTile((IBlockAccess)world, blockPos, TileAdvancedSpawner.class).map(te -> SpawnerSettings.spawnsHostileNpcs(te.getSettings())).orElse(false).booleanValue()) continue;
            onHostileSpawnerFound.accept(blockPos);
            return false;
        }
        return true;
    }

    public static boolean checkBBNotConquered(World world, StructureBB bb) {
        try {
            return (Boolean)STRUCTURE_BB_CONQUERED.get((Object)bb, () -> ConquerHelper.checkBBConquered(world, bb)) == false;
        }
        catch (ExecutionException e) {
            AncientWarfareNPC.LOG.error("Error getting conquered structureBB info ", (Throwable)e);
            return false;
        }
    }
}

