/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.registry.TerritorySettingRegistry;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryManager;

public class Territory
implements INBTSerializable<NBTTagCompound> {
    private String territoryId;
    private String territoryName;
    private int totalClusterValue = 0;
    private Set<Long> chunkPositions = new HashSet<Long>();
    private BlockPos territoryCenter = BlockPos.field_177992_a;
    private Set<BlockPos> chunkCenters = new HashSet<BlockPos>();

    Territory() {
    }

    Territory(String territoryId, String territoryName) {
        this.territoryId = territoryId;
        this.territoryName = territoryName;
    }

    String getTerritoryId() {
        return this.territoryId;
    }

    public void addClusterValue(int value) {
        this.totalClusterValue += value;
    }

    void addChunk(long chunkPos) {
        this.chunkPositions.add(chunkPos);
        this.chunkCenters.add(this.getChunkCenter(chunkPos));
        this.territoryCenter = TerritoryManager.getTerritoryCenter(this.chunkCenters);
    }

    private BlockPos getChunkCenter(long chunkPos) {
        return TerritoryManager.getChunkCenterPos((int)(chunkPos & 0xFFFFFFFFL), (int)(chunkPos >> 32 & 0xFFFFFFFFL));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Territory territory = (Territory)o;
        return this.territoryId.equals(territory.territoryId);
    }

    public int hashCode() {
        return Objects.hash(this.territoryId);
    }

    public String getTerritoryName() {
        return this.territoryName;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74778_a("territoryId", this.territoryId);
        ret.func_74778_a("territoryName", this.territoryName);
        ret.func_74768_a("totalClusterValue", this.totalClusterValue);
        ret.func_74782_a("chunkPositions", (NBTBase)NBTHelper.getTagList(this.chunkPositions, NBTTagLong::new));
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.territoryId = nbt.func_74779_i("territoryId");
        this.territoryName = nbt.func_74779_i("territoryName");
        this.totalClusterValue = nbt.func_74762_e("totalClusterValue");
        this.chunkPositions = NBTHelper.getSet(nbt.func_150295_c("chunkPositions", 4), n -> ((NBTTagLong)n).func_150291_c());
        this.chunkCenters.clear();
        this.chunkPositions.forEach(cp -> this.chunkCenters.add(this.getChunkCenter((long)cp)));
        this.territoryCenter = TerritoryManager.getTerritoryCenter(this.chunkCenters);
    }

    Set<Long> getChunkPositions() {
        return this.chunkPositions;
    }

    public BlockPos getTerritoryCenter() {
        return this.territoryCenter;
    }

    public int getRemainingClusterValue() {
        return (int)(TerritorySettingRegistry.getTerritorySettings(this.territoryName).getPerChunkClusterValueMultiplier() * AWStructureStatics.chunkClusterValue * (float)this.chunkPositions.size()) - this.totalClusterValue;
    }
}

