/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.worldgen.ITerritoryData;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;

public class TerritoryData
implements ITerritoryData {
    private Map<String, Territory> territories = new HashMap<String, Territory>();
    private Map<Long, Territory> chunkOwnership = new HashMap<Long, Territory>();
    private Map<String, Integer> territoryIds = new HashMap<String, Integer>();

    @Override
    public int getNextTerritoryId(String territoryName) {
        int id = this.territoryIds.getOrDefault(territoryName, 0);
        this.territoryIds.put(territoryName, ++id);
        return id;
    }

    @Override
    public Optional<Territory> getTerritory(long chunkPosValue) {
        return Optional.ofNullable(this.chunkOwnership.get(chunkPosValue));
    }

    @Override
    public boolean isOwned(long chunkPos) {
        return this.chunkOwnership.containsKey(chunkPos);
    }

    @Override
    public void setOwned(long chunkPos, String territoryId, String territoryName) {
        Territory territory = this.territories.getOrDefault(territoryId, new Territory(territoryId, territoryName));
        territory.addChunk(chunkPos);
        this.territories.put(territoryId, territory);
        this.chunkOwnership.put(chunkPos, territory);
    }

    @Override
    public boolean isDifferentTerritory(String territoryId, int x, int z) {
        long chunkPosValue = ChunkPos.func_77272_a((int)x, (int)z);
        return !this.chunkOwnership.containsKey(chunkPosValue) || !this.chunkOwnership.get(chunkPosValue).getTerritoryId().equals(territoryId);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74782_a("territories", (NBTBase)NBTHelper.getTagList(this.territories.values(), Territory::serializeNBT));
        ret.func_74782_a("territoryIds", (NBTBase)NBTHelper.mapToCompoundList(this.territoryIds, (t, k) -> t.func_74778_a("territoryName", k), (t, v) -> t.func_74768_a("id", v.intValue())));
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.territories.clear();
        this.territoryIds.clear();
        this.chunkOwnership.clear();
        Set<Territory> territorySet = NBTHelper.getSet(nbt.func_150295_c("territories", 10), n -> {
            Territory territory = new Territory();
            territory.deserializeNBT((NBTTagCompound)n);
            return territory;
        });
        for (Territory t : territorySet) {
            this.territories.put(t.getTerritoryId(), t);
            for (long chunkPos : t.getChunkPositions()) {
                this.chunkOwnership.put(chunkPos, t);
            }
        }
        this.territoryIds = NBTHelper.getMap(nbt.func_150295_c("territoryIds", 10), n -> n.func_74779_i("territoryName"), n -> n.func_74762_e("id"));
    }
}

