/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers;

import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;

public class CatapultVarHelper
extends VehicleFiringVarsHelper {
    public float armAngle = 0.0f;
    public float armSpeed = 0.0f;
    public float crankAngle = 0.0f;
    public float crankSpeed = 0.0f;

    public CatapultVarHelper(VehicleBase vehicle) {
        super(vehicle);
    }

    @Override
    public void onFiringUpdate() {
        float prevAngle = this.armAngle;
        this.armAngle += 4.0f;
        if (this.armAngle >= 70.0f) {
            this.vehicle.firingHelper.startLaunching();
            this.armAngle = 70.0f;
        }
        this.armSpeed = this.armAngle - prevAngle;
    }

    @Override
    public void onLaunchingUpdate() {
        for (int i = 0; i < 1; ++i) {
            this.vehicle.firingHelper.spawnMissilesByWeightCount(0.0f, 0.0f, 0.0f);
        }
        this.vehicle.firingHelper.setFinishedLaunching();
    }

    @Override
    public void onReloadUpdate() {
        float prevAngle = this.armAngle;
        this.armAngle -= 80.0f / (float)(this.vehicle.currentReloadTicks - 2);
        this.crankAngle += 4.0f;
        this.crankSpeed = 4.0f;
        this.armSpeed = this.armAngle - prevAngle;
        if (this.armAngle <= 0.0f) {
            this.armAngle = 0.0f;
            this.crankSpeed = 0.0f;
            this.armSpeed = 0.0f;
        }
    }

    @Override
    public void onReloadingFinished() {
        this.crankSpeed = 0.0f;
        this.armSpeed = 0.0f;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("cA", this.crankAngle);
        tag.func_74776_a("cS", this.crankSpeed);
        tag.func_74776_a("aA", this.armAngle);
        tag.func_74776_a("aS", this.armSpeed);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.crankAngle = tag.func_74760_g("cA");
        this.crankSpeed = tag.func_74760_g("cS");
        this.armAngle = tag.func_74760_g("aA");
        this.armSpeed = tag.func_74760_g("aS");
    }

    @Override
    public float getVar1() {
        return this.armAngle;
    }

    @Override
    public float getVar2() {
        return this.armSpeed;
    }

    @Override
    public float getVar3() {
        return this.crankAngle;
    }

    @Override
    public float getVar4() {
        return this.crankSpeed;
    }

    @Override
    public float getVar5() {
        return 0.0f;
    }

    @Override
    public float getVar6() {
        return 0.0f;
    }

    @Override
    public float getVar7() {
        return 0.0f;
    }

    @Override
    public float getVar8() {
        return 0.0f;
    }
}

