/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.materials;

import net.shadowmage.ancientwarfare.vehicle.AncientWarfareVehicles;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.IVehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.MaterialLevel;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterialIron;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterialWood;

public class VehicleMaterial
implements IVehicleMaterial {
    public static VehicleMaterial materialWood = new VehicleMaterialWood();
    public static VehicleMaterial materialIron = new VehicleMaterialIron();
    public MaterialLevel[] materialLevels;

    public VehicleMaterial(int levelCount) {
        this.materialLevels = new MaterialLevel[levelCount];
    }

    private MaterialLevel getLevel(int num) {
        if (num < 0 || num >= this.materialLevels.length) {
            AncientWarfareVehicles.LOG.error("out of range vehicle material requested. num: " + num + " current levels: " + this.materialLevels.length);
            return new MaterialLevel();
        }
        return this.materialLevels[num];
    }

    @Override
    public int getNumOfLevels() {
        return this.materialLevels.length;
    }

    @Override
    public float getHPFactor(int level) {
        return this.getLevel((int)level).hpFactor;
    }

    @Override
    public float getSpeedForwardFactor(int level) {
        return this.getLevel((int)level).speedForwardFactor;
    }

    @Override
    public float getSpeedStrafeFactor(int level) {
        return this.getLevel((int)level).speedStrafeFactor;
    }

    @Override
    public float getWeightFactor(int level) {
        return this.getLevel((int)level).weightFactor;
    }

    @Override
    public float getAccuracyFactor(int level) {
        return this.getLevel((int)level).accuracyFactor;
    }

    @Override
    public float getMisfireChance(int level) {
        return this.getLevel((int)level).misfireChance;
    }

    @Override
    public String getDisplayName(int level) {
        return this.getLevel((int)level).displayName;
    }
}

