/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers.BatteringRamVarHelper;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.init.AWVehicleSounds;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeBatteringRam
extends VehicleType {
    public VehicleTypeBatteringRam(int typeNum) {
        super(typeNum);
        this.configName = "battering_ram";
        this.baseHealth = AWVehicleStatics.vehicleStats.vehicleBatteringRamHealth;
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.validUpgrades.add(UpgradeRegistry.speedUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.width = 2.7f;
        this.height = 2.1f;
        this.mountable = true;
        this.drivable = true;
        this.combatEngine = true;
        this.powerAdjustable = false;
        this.pitchAdjustable = false;
        this.yawAdjustable = false;
        this.riderSits = true;
        this.riderMovesWithTurret = false;
        this.accuracy = 0.99f;
        this.baseStrafeSpeed = 1.0f;
        this.baseForwardSpeed = 0.22500001f;
        this.basePitchMax = 0.0f;
        this.basePitchMin = 0.0f;
        this.turretRotationMax = 0.0f;
        this.turretForwardsOffset = 2.6f;
        this.turretVerticalOffset = 1.8f;
        this.turretHorizontalOffset = -0.3f;
        this.minAttackDistance = 1.0f;
        this.riderForwardsOffset = 0.0f;
        this.riderVerticalOffset = 0.65f;
        this.riderHorizontalOffset = 0.325f;
        this.displayName = "item.vehicleSpawner.8";
        this.displayTooltip.add("item.vehicleSpawner.tooltip.weight");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.mobile");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.noturret");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.ram");
        this.storageBaySize = 0;
        this.armorBaySize = 6;
        this.upgradeBaySize = 3;
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new BatteringRamVarHelper(veh);
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/battering_ram_1.png");
    }

    public static BlockPos[] getEffectedPositions(VehicleBase vehicle) {
        BlockPos blockHit;
        BlockPos[] positions = new BlockPos[7];
        Vec3d offset = vehicle.getMissileOffset();
        float bx = (float)(vehicle.field_70165_t + offset.field_72450_a);
        float by = (float)(vehicle.field_70163_u + offset.field_72448_b);
        float bz = (float)(vehicle.field_70161_v + offset.field_72449_c);
        positions[0] = blockHit = new BlockPos((double)bx, (double)by, (double)bz);
        positions[1] = new BlockPos(blockHit.func_177958_n() - 1, blockHit.func_177956_o(), blockHit.func_177952_p());
        positions[2] = new BlockPos(blockHit.func_177958_n(), blockHit.func_177956_o() - 1, blockHit.func_177952_p());
        positions[3] = new BlockPos(blockHit.func_177958_n(), blockHit.func_177956_o(), blockHit.func_177952_p() - 1);
        positions[4] = new BlockPos(blockHit.func_177958_n() + 1, blockHit.func_177956_o(), blockHit.func_177952_p());
        positions[5] = new BlockPos(blockHit.func_177958_n(), blockHit.func_177956_o() + 1, blockHit.func_177952_p());
        positions[6] = new BlockPos(blockHit.func_177958_n(), blockHit.func_177956_o(), blockHit.func_177952_p() + 1);
        return positions;
    }

    @Override
    public void playFiringSound(VehicleBase vehicleBase) {
        vehicleBase.func_184185_a(AWVehicleSounds.BATTERING_RAM_LAUNCH, 2.0f, 1.0f);
    }
}

