/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers.BallistaVarHelper;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.init.AWVehicleSounds;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeBoatBallista
extends VehicleType {
    public VehicleTypeBoatBallista(int typeNum) {
        super(typeNum);
        this.configName = "boat_ballista";
        this.baseHealth = AWVehicleStatics.vehicleStats.vehicleBallistaBoatHealth;
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.materialCount = 5;
        this.movementType = VehicleMovementType.WATER;
        this.maxMissileWeight = 2.0f;
        this.validAmmoTypes.add(AmmoRegistry.ammoBallistaBolt);
        this.validAmmoTypes.add(AmmoRegistry.ammoBallistaBoltFlame);
        this.validAmmoTypes.add(AmmoRegistry.ammoBallistaBoltExplosive);
        this.validAmmoTypes.add(AmmoRegistry.ammoBallistaBoltIron);
        this.ammoBySoldierRank.put(0, AmmoRegistry.ammoBallistaBolt);
        this.ammoBySoldierRank.put(1, AmmoRegistry.ammoBallistaBolt);
        this.ammoBySoldierRank.put(2, AmmoRegistry.ammoBallistaBoltFlame);
        this.validUpgrades.add(UpgradeRegistry.speedUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchDownUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchUpUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchExtUpgrade);
        this.validUpgrades.add(UpgradeRegistry.powerUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.validUpgrades.add(UpgradeRegistry.aimUpgrade);
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.armorBaySize = 3;
        this.upgradeBaySize = 3;
        this.ammoBaySize = 6;
        this.storageBaySize = 0;
        this.width = 2.7f;
        this.height = 1.4f;
        this.baseStrafeSpeed = 2.0f;
        this.baseForwardSpeed = 0.31f;
        this.turretForwardsOffset = 1.4375f;
        this.turretVerticalOffset = 1.325f;
        this.accuracy = 0.98f;
        this.basePitchMax = 15.0f;
        this.basePitchMin = -15.0f;
        this.baseMissileVelocityMax = 42.0f;
        this.riderForwardsOffset = -1.0f;
        this.riderVerticalOffset = 0.55f;
        this.riderSits = true;
        this.mountable = true;
        this.drivable = true;
        this.combatEngine = true;
        this.pitchAdjustable = true;
        this.powerAdjustable = false;
        this.yawAdjustable = true;
        this.turretRotationMax = 360.0f;
        this.displayName = "item.vehicleSpawner.18";
        this.displayTooltip.add("item.vehicleSpawner.tooltip.torsion");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.boat");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.fullturret");
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/boat_ballista_1.png");
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new BallistaVarHelper(veh);
    }

    @Override
    public void playReloadSound(VehicleBase vehicleBase) {
        vehicleBase.func_184185_a(AWVehicleSounds.BALLISTA_RELOAD, 1.0f, 1.0f);
    }

    @Override
    public void playFiringSound(VehicleBase vehicleBase) {
        vehicleBase.func_184185_a(AWVehicleSounds.BALLISTA_LAUNCH, 6.0f, 1.0f);
    }
}

