/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.init.AWVehicleSounds;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeTrebuchet
extends VehicleType {
    public VehicleTypeTrebuchet(int typeNum) {
        super(typeNum);
        this.configName = "trebuchet_base";
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.materialCount = 8;
        this.maxMissileWeight = 10.0f;
        this.baseHealth = AWVehicleStatics.vehicleStats.vehicleTrebuchetHealth;
        this.validAmmoTypes.add(AmmoRegistry.ammoStoneShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoStoneShot15);
        this.validAmmoTypes.add(AmmoRegistry.ammoFireShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoFireShot15);
        this.validAmmoTypes.add(AmmoRegistry.ammoPebbleShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoPebbleShot15);
        this.validAmmoTypes.add(AmmoRegistry.ammoClusterShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoClusterShot15);
        this.validAmmoTypes.add(AmmoRegistry.ammoExplosive10);
        this.validAmmoTypes.add(AmmoRegistry.ammoExplosive15);
        this.validAmmoTypes.add(AmmoRegistry.ammoHE10);
        this.validAmmoTypes.add(AmmoRegistry.ammoHE15);
        this.validAmmoTypes.add(AmmoRegistry.ammoNapalm10);
        this.validAmmoTypes.add(AmmoRegistry.ammoNapalm15);
        if (AWVehicleStatics.generalSettings.oversizeAmmoEnabled) {
            this.validAmmoTypes.add(AmmoRegistry.ammoStoneShot30);
            this.validAmmoTypes.add(AmmoRegistry.ammoStoneShot45);
            this.validAmmoTypes.add(AmmoRegistry.ammoFireShot30);
            this.validAmmoTypes.add(AmmoRegistry.ammoFireShot45);
            this.validAmmoTypes.add(AmmoRegistry.ammoPebbleShot30);
            this.validAmmoTypes.add(AmmoRegistry.ammoPebbleShot45);
            this.validAmmoTypes.add(AmmoRegistry.ammoClusterShot30);
            this.validAmmoTypes.add(AmmoRegistry.ammoClusterShot45);
            this.validAmmoTypes.add(AmmoRegistry.ammoExplosive30);
            this.validAmmoTypes.add(AmmoRegistry.ammoExplosive45);
            this.validAmmoTypes.add(AmmoRegistry.ammoHE30);
            this.validAmmoTypes.add(AmmoRegistry.ammoHE45);
        }
        this.ammoBySoldierRank.put(0, AmmoRegistry.ammoStoneShot10);
        this.ammoBySoldierRank.put(1, AmmoRegistry.ammoStoneShot10);
        this.ammoBySoldierRank.put(2, AmmoRegistry.ammoStoneShot10);
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.validUpgrades.add(UpgradeRegistry.pitchDownUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchUpUpgrade);
        this.validUpgrades.add(UpgradeRegistry.powerUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.validUpgrades.add(UpgradeRegistry.aimUpgrade);
        this.displayName = "Trebuchet";
        this.pitchAdjustable = false;
        this.powerAdjustable = true;
        this.yawAdjustable = false;
        this.mountable = true;
        this.combatEngine = true;
        this.drivable = true;
        this.riderSits = false;
        this.riderMovesWithTurret = false;
        this.baseForwardSpeed = 0.0f;
        this.baseStrafeSpeed = 0.5f;
        this.ammoBaySize = 6;
        this.armorBaySize = 3;
        this.upgradeBaySize = 3;
        this.storageBaySize = 0;
        this.accuracy = 0.85f;
        this.basePitchMax = 70.0f;
        this.basePitchMin = 70.0f;
        this.turretVerticalOffset = 7.84375f;
        this.baseMissileVelocityMax = 40.0f;
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/trebuchet_1.png");
    }

    @Override
    public void playFiringSound(VehicleBase vehicleBase) {
        vehicleBase.func_184185_a(AWVehicleSounds.TREBUCHET_LAUNCH, 6.0f, 1.0f);
    }

    @Override
    public void playReloadSound(VehicleBase vehicleBase) {
        vehicleBase.func_184185_a(AWVehicleSounds.TREBUCHET_RELOAD, 2.0f, 1.0f);
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new TrebuchetVarHelper(veh);
    }

    public class TrebuchetVarHelper
    extends VehicleFiringVarsHelper {
        private float armAngle;
        private float armSpeed;
        private float stringAngle;
        private float stringSpeed;

        private TrebuchetVarHelper(VehicleBase vehicle) {
            super(vehicle);
            this.armAngle = -27.0f;
            this.armSpeed = 0.0f;
            this.stringAngle = -64.0f;
            this.stringSpeed = 0.0f;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("aA", this.armAngle);
            tag.func_74776_a("aS", this.armSpeed);
            tag.func_74776_a("sA", this.stringAngle);
            tag.func_74776_a("sS", this.stringSpeed);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.armAngle = tag.func_74760_g("aA");
            this.armSpeed = tag.func_74760_g("aS");
            this.stringAngle = tag.func_74760_g("sA");
            this.stringSpeed = tag.func_74760_g("sS");
        }

        @Override
        public void onFiringUpdate() {
            float increment = 5.85f;
            this.armAngle += increment;
            this.armSpeed = increment;
            this.stringAngle += 1.3162316f * increment;
            this.stringSpeed = 1.3162316f * increment;
            if (this.armAngle >= 90.0f) {
                this.armSpeed = 0.0f;
                this.armAngle = 90.0f;
                this.stringAngle = 90.0f;
                this.stringSpeed = 0.0f;
                this.vehicle.firingHelper.startLaunching();
            }
        }

        @Override
        public void onReloadUpdate() {
            float increment = 117.0f / (float)this.vehicle.currentReloadTicks;
            if (this.armAngle > -27.0f) {
                this.armAngle -= increment;
                this.armSpeed = -increment;
                this.stringAngle -= 1.3162316f * increment;
                this.stringSpeed = -1.3162316f * increment;
            } else {
                this.armAngle = -27.0f;
                this.armSpeed = 0.0f;
                this.stringAngle = -64.0f;
                this.stringSpeed = 0.0f;
            }
        }

        @Override
        public void onLaunchingUpdate() {
            this.vehicle.firingHelper.spawnMissilesByWeightCount(0.0f, 0.0f, 0.0f);
            this.vehicle.firingHelper.setFinishedLaunching();
        }

        @Override
        public void onReloadingFinished() {
            this.armAngle = -27.0f;
            this.armSpeed = 0.0f;
            this.stringAngle = -64.0f;
            this.stringSpeed = 0.0f;
        }

        @Override
        public float getVar1() {
            return this.armAngle;
        }

        @Override
        public float getVar2() {
            return this.armSpeed;
        }

        @Override
        public float getVar3() {
            return this.stringAngle;
        }

        @Override
        public float getVar4() {
            return this.stringSpeed;
        }

        @Override
        public float getVar5() {
            return 0.0f;
        }

        @Override
        public float getVar6() {
            return 0.0f;
        }

        @Override
        public float getVar7() {
            return 0.0f;
        }

        @Override
        public float getVar8() {
            return 0.0f;
        }
    }
}

