/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.helpers;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.Function2;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.NpcSiegeEngineer;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.network.PacketAmmoSelect;
import net.shadowmage.ancientwarfare.vehicle.network.PacketAmmoUpdate;
import net.shadowmage.ancientwarfare.vehicle.network.PacketSingleAmmoUpdate;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.VehicleAmmoEntry;

public class VehicleAmmoHelper
implements INBTSerializable<NBTTagCompound> {
    private static final String CURRENT_AMMO_TYPE_TAG = "currentAmmoType";
    private VehicleBase vehicle;
    private ResourceLocation currentAmmoType = null;
    private NavigableMap<ResourceLocation, VehicleAmmoEntry> ammoEntries = new TreeMap<ResourceLocation, VehicleAmmoEntry>();

    public VehicleAmmoHelper(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    public int getCountOf(IAmmo type) {
        VehicleAmmoEntry ammo = (VehicleAmmoEntry)this.ammoEntries.get(type.getRegistryName());
        return ammo == null ? 0 : ammo.ammoCount;
    }

    void decreaseCurrentAmmo() {
        if (this.vehicle.field_70170_p.field_72995_K) {
            return;
        }
        if (this.currentAmmoType != null && this.ammoEntries.containsKey(this.currentAmmoType)) {
            int removed = InventoryTools.removeItems((IItemHandler)this.vehicle.inventory.ammoInventory, new ItemStack((Item)AmmoRegistry.getItem(this.currentAmmoType)), 1).func_190916_E();
            VehicleAmmoEntry entry = (VehicleAmmoEntry)this.ammoEntries.get(this.currentAmmoType);
            int origCount = entry.ammoCount;
            entry.ammoCount -= removed;
            if (entry.ammoCount < 0) {
                entry.ammoCount = 0;
            }
            if (entry.ammoCount != origCount) {
                NetworkHandler.sendToAllTracking(this.vehicle, new PacketSingleAmmoUpdate(this.vehicle, this.currentAmmoType.toString(), entry.ammoCount));
            }
        }
    }

    public int getCurrentAmmoCount() {
        if (this.vehicle.func_184179_bs() instanceof NpcFaction || AWVehicleStatics.generalSettings.ownedSoldiersUseAmmo && this.vehicle.func_184179_bs() instanceof NpcSiegeEngineer) {
            return 64;
        }
        if (this.currentAmmoType != null && this.ammoEntries.containsKey(this.currentAmmoType)) {
            return ((VehicleAmmoEntry)this.ammoEntries.get((Object)this.currentAmmoType)).ammoCount;
        }
        return 0;
    }

    boolean doesntUseAmmo() {
        return this.vehicle.vehicleType.getValidAmmoTypes().isEmpty();
    }

    public void addUseableAmmo(IAmmo ammo) {
        VehicleAmmoEntry ent = new VehicleAmmoEntry(ammo);
        this.ammoEntries.put(ammo.getRegistryName(), ent);
    }

    public void setNextAmmo() {
        this.getAvailable(this::getHigherWrapped).ifPresent(this::setCurrentAmmo);
    }

    private <K, V> Map.Entry<K, V> getHigherWrapped(NavigableMap<K, V> map, K key) {
        Map.Entry<K, V> entry = map.higherEntry(key);
        return entry == null ? map.firstEntry() : entry;
    }

    private void setCurrentAmmo(ResourceLocation registryName) {
        this.currentAmmoType = registryName;
        this.handleClientAmmoSelection(this.currentAmmoType);
    }

    private Optional<ResourceLocation> getAvailable(Function2<NavigableMap<ResourceLocation, VehicleAmmoEntry>, ResourceLocation, Map.Entry<ResourceLocation, VehicleAmmoEntry>> getNextEntry) {
        if (this.currentAmmoType == null) {
            return Optional.empty();
        }
        Map.Entry<ResourceLocation, VehicleAmmoEntry> entry = getNextEntry.apply(this.ammoEntries, this.currentAmmoType);
        while (entry.getValue().ammoCount <= 0 && !this.currentAmmoType.equals((Object)entry.getKey())) {
            entry = getNextEntry.apply(this.ammoEntries, entry.getKey());
        }
        return Optional.of(entry.getKey());
    }

    private <K, V> Map.Entry<K, V> getLowerWrapped(NavigableMap<K, V> map, K key) {
        Map.Entry<K, V> entry = map.lowerEntry(key);
        return entry == null ? map.lastEntry() : entry;
    }

    public void setPreviousAmmo() {
        this.getAvailable(this::getLowerWrapped).ifPresent(this::setCurrentAmmo);
    }

    public void handleClientAmmoSelection(ResourceLocation ammoRegistryName) {
        NetworkHandler.sendToServer(new PacketAmmoSelect(this.vehicle, ammoRegistryName.toString()));
    }

    public void updateSelectedAmmo(String ammoRegistryName) {
        if (!ammoRegistryName.equals(this.currentAmmoType == null ? "" : this.currentAmmoType.toString())) {
            this.currentAmmoType = new ResourceLocation(ammoRegistryName);
            if (!this.vehicle.field_70170_p.field_72995_K) {
                NetworkHandler.sendToAllTracking(this.vehicle, new PacketAmmoSelect(this.vehicle, ammoRegistryName));
            }
            float maxPower = this.vehicle.firingHelper.getAdjustedMaxMissileVelocity();
            if (!this.vehicle.canAimPower()) {
                this.vehicle.localLaunchPower = maxPower;
            } else if (this.vehicle.localLaunchPower > maxPower) {
                this.vehicle.localLaunchPower = maxPower;
                if (this.vehicle.field_70170_p.field_72995_K && this.vehicle.firingHelper.clientLaunchSpeed > maxPower) {
                    this.vehicle.firingHelper.clientLaunchSpeed = maxPower;
                }
            }
        }
    }

    public void updateAmmoCount(String registryName, int count) {
        ResourceLocation rl = new ResourceLocation(registryName);
        this.updateAmmoCount(rl, count);
    }

    private void updateAmmoCount(ResourceLocation registryNameLocation, int count) {
        if (this.ammoEntries.containsKey(registryNameLocation)) {
            ((VehicleAmmoEntry)this.ammoEntries.get((Object)registryNameLocation)).ammoCount = count;
        }
    }

    public void updateAmmoCounts() {
        if (this.vehicle.field_70170_p.field_72995_K) {
            return;
        }
        for (Object ent : this.ammoEntries.values()) {
            ((VehicleAmmoEntry)ent).ammoCount = 0;
        }
        List<VehicleAmmoEntry> counts = this.vehicle.inventory.getAmmoCounts();
        for (VehicleAmmoEntry count : counts) {
            this.updateAmmoCount(count.baseAmmoType.getRegistryName(), count.ammoCount);
            if (this.currentAmmoType != null || count.ammoCount <= 0) continue;
            this.updateSelectedAmmo(count.baseAmmoType.getRegistryName().toString());
        }
        PacketAmmoUpdate pkt = new PacketAmmoUpdate(this.vehicle, this.serializeAmmo(new NBTTagCompound()));
        NetworkHandler.sendToAllTracking(this.vehicle, pkt);
    }

    @Nullable
    public IAmmo getCurrentAmmoType() {
        VehicleAmmoEntry entry;
        if (this.currentAmmoType != null && this.ammoEntries.containsKey(this.currentAmmoType) && (entry = (VehicleAmmoEntry)this.ammoEntries.get(this.currentAmmoType)) != null && (!(this.vehicle.func_184179_bs() instanceof NpcBase) || entry.ammoCount > 0)) {
            return entry.baseAmmoType;
        }
        if (this.vehicle.func_184179_bs() instanceof NpcFaction || !AWVehicleStatics.generalSettings.ownedSoldiersUseAmmo && this.vehicle.func_184179_bs() instanceof NpcSiegeEngineer) {
            NpcBase npc = (NpcBase)this.vehicle.func_184179_bs();
            return this.vehicle.vehicleType.getAmmoForSoldierRank(npc.getLevelingStats().getLevel());
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.currentAmmoType != null) {
            tag.func_74778_a(CURRENT_AMMO_TYPE_TAG, this.currentAmmoType.toString());
        }
        this.serializeAmmo(tag);
        return tag;
    }

    private NBTTagCompound serializeAmmo(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (VehicleAmmoEntry ent : this.ammoEntries.values()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("type", ent.baseAmmoType.getRegistryName().toString());
            entryTag.func_74768_a("count", ent.ammoCount);
            tagList.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("list", (NBTBase)tagList);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        for (VehicleAmmoEntry ent : this.ammoEntries.values()) {
            ent.ammoCount = 0;
        }
        if (tag.func_74764_b(CURRENT_AMMO_TYPE_TAG)) {
            this.currentAmmoType = new ResourceLocation(tag.func_74779_i(CURRENT_AMMO_TYPE_TAG));
        }
        this.deserializeAmmo(tag);
    }

    public void updateAmmo(NBTTagCompound tag) {
        for (VehicleAmmoEntry ent : this.ammoEntries.values()) {
            ent.ammoCount = 0;
        }
        this.deserializeAmmo(tag);
    }

    private void deserializeAmmo(NBTTagCompound tag) {
        NBTTagList ammo = tag.func_150295_c("list", 10);
        for (int i = 0; i < ammo.func_74745_c(); ++i) {
            NBTTagCompound entryTag = (NBTTagCompound)ammo.func_179238_g(i);
            String type = entryTag.func_74779_i("type");
            int count = entryTag.func_74762_e("count");
            this.updateAmmoCount(type, count);
        }
    }
}

