/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.helpers;

import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.ITarget;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;
import net.shadowmage.ancientwarfare.vehicle.network.PacketAimUpdate;
import net.shadowmage.ancientwarfare.vehicle.network.PacketFireUpdate;

public class VehicleFiringHelper
implements INBTSerializable<NBTTagCompound> {
    private static final int TRAJECTORY_ITERATIONS_CLIENT = 20;
    protected static Random rng = new Random();
    public float clientHitRange = 0.0f;
    public float clientHitPosX = 0.0f;
    public float clientHitPosY = 0.0f;
    public float clientHitPosZ = 0.0f;
    public float clientTurretYaw = 0.0f;
    public float clientTurretPitch = 0.0f;
    public float clientLaunchSpeed = 0.0f;
    public Vec3d targetPos = null;
    private boolean isFiring = false;
    private boolean isLaunching = false;
    private boolean isReloading = false;
    private int reloadingTicks = 0;
    private VehicleBase vehicle;
    private static final float NEGLIGIBLE_ANGLE_DIFFERENCE = 0.35f;

    public VehicleFiringHelper(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    public void spawnMissilesByWeightCount(float ox, float oy, float oz) {
        int count = this.getMissileLaunchCount();
        for (int i = 0; i < count; ++i) {
            this.spawnMissile(ox, oy, oz);
        }
    }

    public void spawnMissile(float ox, float oy, float oz) {
        if (!this.vehicle.field_70170_p.field_72995_K) {
            IAmmo ammo = this.vehicle.ammoHelper.getCurrentAmmoType();
            if (ammo == null) {
                return;
            }
            if (this.vehicle.ammoHelper.getCurrentAmmoCount() > 0) {
                this.vehicle.ammoHelper.decreaseCurrentAmmo();
                Vec3d off = this.vehicle.getMissileOffset();
                float x = (float)(this.vehicle.field_70165_t + off.field_72450_a + (double)ox);
                float y = (float)(this.vehicle.field_70163_u + off.field_72448_b + (double)oy);
                float z = (float)(this.vehicle.field_70161_v + off.field_72449_c + (double)oz);
                int count = ammo.hasSecondaryAmmo() ? ammo.getSecondaryAmmoTypeCount() : 1;
                MissileBase missile = null;
                for (int i = 0; i < count; ++i) {
                    float maxPower = this.getAdjustedMaxMissileVelocity();
                    float power = Math.min(this.vehicle.localLaunchPower, maxPower);
                    float yaw = this.vehicle.localTurretRotation;
                    float pitch = this.vehicle.localTurretPitch + this.vehicle.field_70125_A;
                    if (AWVehicleStatics.clientSettings.adjustMissilesForAccuracy) {
                        float accuracy = this.getAccuracyAdjusted();
                        yaw += (float)rng.nextGaussian() * (1.0f - accuracy) * 10.0f;
                        if (this.vehicle.canAimPower() && !ammo.isRocket()) {
                            if ((power += (float)rng.nextGaussian() * (1.0f - accuracy) * 2.5f) < 1.0f) {
                                power = 1.0f;
                            }
                        } else if (this.vehicle.canAimPitch()) {
                            pitch += (float)rng.nextGaussian() * (1.0f - accuracy) * 10.0f;
                        } else if (ammo != null && ammo.isRocket()) {
                            power += power / this.vehicle.currentLaunchSpeedPowerMax;
                            pitch += (rng.nextFloat() * 2.0f - 1.0f) * (1.0f - accuracy) * 50.0f;
                        }
                    }
                    missile = this.getMissile2(x, y, z, yaw, pitch, power);
                    if (this.vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR1 || this.vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR2) {
                        missile.field_70159_w += this.vehicle.field_70159_w;
                        missile.field_70181_x += this.vehicle.field_70181_x;
                        missile.field_70179_y += this.vehicle.field_70179_y;
                    }
                    if (missile == null) continue;
                    this.vehicle.field_70170_p.func_72838_d((Entity)missile);
                }
            }
        }
    }

    MissileBase getMissile2(float x, float y, float z, float yaw, float pitch, float velocity) {
        IAmmo ammo = this.vehicle.ammoHelper.getCurrentAmmoType();
        if (ammo != null) {
            MissileBase missile = new MissileBase(this.vehicle.field_70170_p);
            if (ammo.hasSecondaryAmmo()) {
                ammo = ammo.getSecondaryAmmoType();
            }
            missile.setMissileParams2(ammo, x, y, z, yaw, pitch, velocity);
            missile.setMissileCallback(this.vehicle);
            missile.setLaunchingEntity(this.vehicle);
            missile.setShooter(this.vehicle.func_184179_bs());
            return missile;
        }
        return null;
    }

    public void onTick() {
        if (this.isReloading) {
            this.vehicle.onReloadUpdate();
            if (this.reloadingTicks <= 0) {
                this.setFinishedReloading();
                this.vehicle.firingVarsHelper.onReloadingFinished();
            }
            --this.reloadingTicks;
        }
        if (this.isFiring) {
            this.vehicle.onFiringUpdate();
        }
        if (this.isLaunching) {
            this.vehicle.onLaunchingUpdate();
        }
        if (this.vehicle.field_70170_p.field_72995_K) {
            if (!this.vehicle.canAimPitch()) {
                this.clientTurretPitch = this.vehicle.localTurretPitch;
            }
            if (!this.vehicle.canAimPower()) {
                this.clientLaunchSpeed = this.vehicle.localLaunchPower;
            }
            if (!this.vehicle.canAimRotate()) {
                this.clientTurretYaw = this.vehicle.field_70177_z;
            }
        }
        if (!this.vehicle.canAimPower()) {
            this.vehicle.localLaunchPower = this.vehicle.currentLaunchSpeedPowerMax;
        }
        if (this.vehicle.canAimRotate()) {
            float diff = this.vehicle.field_70177_z - this.vehicle.field_70126_B;
            this.vehicle.localTurretRotation += diff;
            this.clientTurretYaw += diff;
        }
    }

    public int getMissileLaunchCount() {
        IAmmo ammo = this.vehicle.ammoHelper.getCurrentAmmoType();
        int missileCount = 1;
        if (ammo != null && (missileCount = (int)(this.vehicle.vehicleType.getMaxMissileWeight() / ammo.getAmmoWeight())) < 1) {
            missileCount = 1;
        }
        return missileCount;
    }

    public float getAdjustedMaxMissileVelocity() {
        float maxWeight;
        float missileWeight;
        float velocity = this.vehicle.currentLaunchSpeedPowerMax;
        IAmmo ammo = this.vehicle.ammoHelper.getCurrentAmmoType();
        if (ammo != null && (missileWeight = ammo.getAmmoWeight()) > (maxWeight = this.vehicle.vehicleType.getMaxMissileWeight())) {
            float totalWeight = missileWeight + maxWeight;
            float temp = maxWeight / totalWeight;
            velocity *= (temp *= 2.0f);
        }
        return velocity;
    }

    private float getAccuracyAdjusted() {
        return this.vehicle.currentAccuracy;
    }

    private void initiateLaunchSequence() {
        if (!this.isFiring && !this.isLaunching && this.reloadingTicks <= 0) {
            this.isFiring = true;
            this.isLaunching = false;
            this.isReloading = false;
            this.vehicle.vehicleType.playFiringSound(this.vehicle);
        }
    }

    private void setFinishedReloading() {
        this.isFiring = false;
        this.isReloading = false;
        this.isLaunching = false;
        this.reloadingTicks = 0;
    }

    public void startLaunching() {
        this.isFiring = false;
        this.isLaunching = true;
        this.isReloading = false;
    }

    public void setFinishedLaunching() {
        this.isFiring = false;
        this.isReloading = true;
        this.isLaunching = false;
        this.reloadingTicks = this.vehicle.currentReloadTicks;
        this.vehicle.vehicleType.playReloadSound(this.vehicle);
    }

    public void handleFireUpdate() {
        if (this.reloadingTicks <= 0 || this.vehicle.field_70170_p.field_72995_K) {
            boolean shouldFire;
            boolean bl = shouldFire = this.vehicle.ammoHelper.getCurrentAmmoCount() > 0 || this.vehicle.ammoHelper.doesntUseAmmo();
            if (shouldFire) {
                if (!this.vehicle.field_70170_p.field_72995_K) {
                    NetworkHandler.sendToAllTracking(this.vehicle, new PacketFireUpdate(this.vehicle));
                }
                this.initiateLaunchSequence();
            }
        }
    }

    public void updateAim(Optional<Float> pitch, Optional<Float> yaw, Optional<Float> power) {
        boolean sendReply = false;
        if (pitch.isPresent()) {
            sendReply = true;
            this.vehicle.localTurretDestPitch = pitch.get().floatValue();
        }
        if (yaw.isPresent()) {
            sendReply = true;
            this.vehicle.localTurretDestRot = yaw.get().floatValue();
        }
        if (power.isPresent()) {
            sendReply = true;
            this.vehicle.localLaunchPower = power.get().floatValue();
        }
        if (!this.vehicle.field_70170_p.field_72995_K && sendReply) {
            NetworkHandler.sendToAllTracking(this.vehicle, new PacketAimUpdate(this.vehicle, pitch, yaw, power));
        }
    }

    public void handleFireInput() {
        if (this.isReadyToFire()) {
            NetworkHandler.sendToServer(new PacketFireUpdate(this.vehicle));
        }
    }

    public boolean isReadyToFire() {
        return !this.isFiring && !this.isLaunching && !this.isReloading && this.hasAmmo();
    }

    private boolean hasAmmo() {
        return this.vehicle.ammoHelper.doesntUseAmmo() || this.vehicle.ammoHelper.getCurrentAmmoCount() > 0 && this.vehicle.ammoHelper.getCurrentAmmoType() != null;
    }

    public void handleAimKeyInput(float pitch, float yaw) {
        boolean pitchUpdated = false;
        boolean powerUpdated = false;
        boolean yawUpdated = false;
        if (this.vehicle.canAimPitch()) {
            float pitchTest = this.clientTurretPitch + pitch;
            if (pitchTest < this.vehicle.currentTurretPitchMin) {
                pitchTest = this.vehicle.currentTurretPitchMin;
            } else if (pitchTest > this.vehicle.currentTurretPitchMax) {
                pitchTest = this.vehicle.currentTurretPitchMax;
            }
            if (!MathUtils.epsilonEquals(pitchTest, this.clientTurretPitch)) {
                pitchUpdated = true;
                this.clientTurretPitch = pitchTest;
            }
        } else if (this.vehicle.canAimPower()) {
            float powerTest = this.clientLaunchSpeed + pitch;
            if (powerTest < 0.0f) {
                powerTest = 0.0f;
            } else if (powerTest > this.getAdjustedMaxMissileVelocity()) {
                powerTest = this.getAdjustedMaxMissileVelocity();
            }
            if (!MathUtils.epsilonEquals(this.clientLaunchSpeed, powerTest)) {
                powerUpdated = true;
                this.clientLaunchSpeed = powerTest;
            }
        }
        if (this.vehicle.canAimRotate()) {
            yawUpdated = true;
            this.clientTurretYaw += yaw;
        }
        if (powerUpdated || pitchUpdated || yawUpdated) {
            Optional<Float> turretPitch = pitchUpdated ? Optional.of(Float.valueOf(this.clientTurretPitch)) : Optional.empty();
            Optional<Float> turretYaw = yawUpdated ? Optional.of(Float.valueOf(this.clientTurretYaw)) : Optional.empty();
            Optional<Float> power = powerUpdated ? Optional.of(Float.valueOf(this.clientLaunchSpeed)) : Optional.empty();
            NetworkHandler.sendToServer(new PacketAimUpdate(this.vehicle, turretPitch, turretYaw, power));
        }
    }

    public void handleAimInput(Vec3d target) {
        float yaw;
        float power;
        boolean updated = false;
        boolean updatePitch = false;
        boolean updatePower = false;
        boolean updateYaw = false;
        Vec3d offset = this.vehicle.getMissileOffset();
        float x = (float)(this.vehicle.field_70165_t + offset.field_72450_a);
        float y = (float)(this.vehicle.field_70163_u + offset.field_72448_b);
        float z = (float)(this.vehicle.field_70161_v + offset.field_72449_c);
        float tx = (float)(target.field_72450_a - (double)x);
        float ty = (float)(target.field_72448_b - (double)y);
        float tz = (float)(target.field_72449_c - (double)z);
        float range = MathHelper.func_76129_c((float)(tx * tx + tz * tz));
        if (this.vehicle.canAimPitch()) {
            Tuple<Float, Float> angles = Trig.getLaunchAngleToHit(tx, ty, tz, this.vehicle.localLaunchPower);
            if (!((Float)angles.func_76341_a()).isNaN() && !((Float)angles.func_76340_b()).isNaN()) {
                if (Trig.isAngleBetween(((Float)angles.func_76340_b()).floatValue(), this.vehicle.currentTurretPitchMin, this.vehicle.currentTurretPitchMax)) {
                    if (!MathUtils.epsilonEquals(this.clientTurretPitch, ((Float)angles.func_76340_b()).floatValue())) {
                        this.clientTurretPitch = ((Float)angles.func_76340_b()).floatValue();
                        updated = true;
                        updatePitch = true;
                    }
                } else if (Trig.isAngleBetween(((Float)angles.func_76341_a()).floatValue(), this.vehicle.currentTurretPitchMin, this.vehicle.currentTurretPitchMax) && !MathUtils.epsilonEquals(this.clientTurretPitch, ((Float)angles.func_76341_a()).floatValue())) {
                    this.clientTurretPitch = ((Float)angles.func_76341_a()).floatValue();
                    updated = true;
                    updatePitch = true;
                }
            }
        } else if (this.vehicle.canAimPower() && !MathUtils.epsilonEquals(this.clientLaunchSpeed, power = Trig.iterativeSpeedFinder(tx, ty, tz, this.vehicle.localTurretPitch + this.vehicle.field_70125_A, 20, this.vehicle.ammoHelper.getCurrentAmmoType() != null && this.vehicle.ammoHelper.getCurrentAmmoType().isRocket())) && power < this.getAdjustedMaxMissileVelocity()) {
            this.clientLaunchSpeed = power;
            updated = true;
            updatePower = true;
        }
        if (this.vehicle.canAimRotate() && !MathUtils.epsilonEquals(yaw = this.getAimYaw(target.field_72450_a, target.field_72449_c), this.clientTurretYaw) && (this.vehicle.currentTurretRotationMax >= 180.0f || Trig.isAngleBetween(yaw, this.vehicle.localTurretRotationHome - this.vehicle.currentTurretRotationMax, this.vehicle.localTurretRotationHome + this.vehicle.currentTurretRotationMax)) && Math.abs(yaw - this.clientTurretYaw) > 0.25f) {
            this.clientTurretYaw = yaw;
            updated = true;
            updateYaw = true;
        }
        if (updated) {
            this.clientHitRange = range;
            Optional<Float> turretPitch = updatePitch ? Optional.of(Float.valueOf(this.clientTurretPitch)) : Optional.empty();
            Optional<Float> turretYaw = updateYaw ? Optional.of(Float.valueOf(this.clientTurretYaw)) : Optional.empty();
            Optional<Float> power2 = updatePower ? Optional.of(Float.valueOf(this.clientLaunchSpeed)) : Optional.empty();
            NetworkHandler.sendToServer(new PacketAimUpdate(this.vehicle, turretPitch, turretYaw, power2));
        }
    }

    public boolean isAtTarget() {
        return this.isAtTarget(0.35f);
    }

    private boolean isAtTarget(float range) {
        float yaw = Trig.wrapTo360(this.vehicle.localTurretRotation);
        float dest = Trig.wrapTo360(this.vehicle.localTurretDestRot);
        return MathUtils.epsilonEquals(this.vehicle.localTurretDestPitch, this.vehicle.localTurretPitch) && Math.abs(yaw - dest) < range;
    }

    public boolean isNearTarget() {
        return this.isAtTarget(5.0f);
    }

    public void handleSoldierTargetInput(double targetX, double targetY, double targetZ) {
        float yaw;
        float power;
        boolean updated = false;
        boolean updatePitch = false;
        boolean updatePower = false;
        boolean updateYaw = false;
        Vec3d offset = this.vehicle.getMissileOffset();
        float x = (float)(this.vehicle.field_70165_t + offset.field_72450_a);
        float y = (float)(this.vehicle.field_70163_u + offset.field_72448_b);
        float z = (float)(this.vehicle.field_70161_v + offset.field_72449_c);
        float tx = (float)(targetX - (double)x);
        float ty = (float)(targetY - (double)y);
        float tz = (float)(targetZ - (double)z);
        if (this.vehicle.canAimPitch()) {
            Tuple<Float, Float> angles = Trig.getLaunchAngleToHit(tx, ty, tz, this.vehicle.localLaunchPower);
            if (!((Float)angles.func_76341_a()).isNaN() && !((Float)angles.func_76340_b()).isNaN()) {
                if (Trig.isAngleBetween(((Float)angles.func_76340_b()).floatValue(), this.vehicle.currentTurretPitchMin, this.vehicle.currentTurretPitchMax)) {
                    if (!MathUtils.epsilonEquals(this.vehicle.localTurretDestPitch, ((Float)angles.func_76340_b()).floatValue())) {
                        this.vehicle.localTurretDestPitch = ((Float)angles.func_76340_b()).floatValue();
                        updated = true;
                        updatePitch = true;
                    }
                } else if (Trig.isAngleBetween(((Float)angles.func_76341_a()).floatValue(), this.vehicle.currentTurretPitchMin, this.vehicle.currentTurretPitchMax) && !MathUtils.epsilonEquals(this.vehicle.localTurretDestPitch, ((Float)angles.func_76341_a()).floatValue())) {
                    this.vehicle.localTurretDestPitch = ((Float)angles.func_76341_a()).floatValue();
                    updated = true;
                    updatePitch = true;
                }
            }
        } else if (this.vehicle.canAimPower() && !MathUtils.epsilonEquals(this.vehicle.localLaunchPower, power = Trig.iterativeSpeedFinder(tx, ty, tz, this.vehicle.localTurretPitch + this.vehicle.field_70125_A, 20, this.vehicle.ammoHelper.getCurrentAmmoType() != null && this.vehicle.ammoHelper.getCurrentAmmoType().isRocket())) && power < this.getAdjustedMaxMissileVelocity()) {
            this.vehicle.localLaunchPower = power;
            updated = true;
            updatePower = true;
        }
        if (this.vehicle.canAimRotate() && !MathUtils.epsilonEquals(yaw = this.getAimYaw(targetX, targetZ), this.vehicle.localTurretDestRot) && (this.vehicle.currentTurretRotationMax >= 180.0f || Trig.isAngleBetween(yaw, this.vehicle.localTurretRotationHome - this.vehicle.currentTurretRotationMax, this.vehicle.localTurretRotationHome + this.vehicle.currentTurretRotationMax))) {
            this.vehicle.localTurretDestRot = yaw;
            updated = true;
            updateYaw = true;
        }
        if (updated && !this.vehicle.field_70170_p.field_72995_K) {
            Optional<Float> turretPitch = updatePitch ? Optional.of(Float.valueOf(this.vehicle.localTurretDestPitch)) : Optional.empty();
            Optional<Float> turretYaw = updateYaw ? Optional.of(Float.valueOf(this.vehicle.localTurretDestRot)) : Optional.empty();
            Optional<Float> power2 = updatePower ? Optional.of(Float.valueOf(this.vehicle.localLaunchPower)) : Optional.empty();
            NetworkHandler.sendToAllTracking(this.vehicle, new PacketAimUpdate(this.vehicle, turretPitch, turretYaw, power2));
        }
    }

    private float getAimYaw(double targetX, double targetZ) {
        Vec3d offset = this.vehicle.getMissileOffset();
        float vecX = (float)(this.vehicle.field_70165_t + (this.vehicle.canTurretTurn() ? offset.field_72450_a : 0.0) - targetX);
        float vecZ = (float)(this.vehicle.field_70161_v + (this.vehicle.canTurretTurn() ? offset.field_72449_c : 0.0) - targetZ);
        return Trig.wrapTo360(Trig.toDegrees((float)Math.atan2(vecX, vecZ)));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("rt", this.reloadingTicks);
        tag.func_74757_a("f", this.isFiring);
        tag.func_74757_a("r", this.isReloading);
        tag.func_74757_a("l", this.isLaunching);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.reloadingTicks = tag.func_74762_e("rt");
        this.isFiring = tag.func_74767_n("f");
        this.isReloading = tag.func_74767_n("r");
        this.isLaunching = tag.func_74767_n("l");
    }

    public boolean isAimedAt(ITarget target) {
        return this.isPitchPointedAt(target) && this.isYawPointedAt(target) && this.isPowerSetToPointAt(target);
    }

    private boolean isYawPointedAt(ITarget target) {
        float maxYaw;
        float minYaw = this.getAimYaw(target.getBoundigBox().field_72340_a, target.getBoundigBox().field_72339_c);
        if (minYaw > (maxYaw = this.getAimYaw(target.getBoundigBox().field_72336_d, target.getBoundigBox().field_72334_f))) {
            float temp = minYaw;
            minYaw = maxYaw;
            maxYaw = temp;
        }
        float vehicleRotation = this.vehicle.canAimRotate() ? this.vehicle.localTurretRotation : this.vehicle.field_70177_z;
        return Trig.isAngleBetween(vehicleRotation, minYaw, maxYaw);
    }

    private boolean isPitchPointedAt(ITarget target) {
        if (!this.vehicle.canAimPitch()) {
            return true;
        }
        Vec3d offset = this.vehicle.getMissileOffset();
        float targetX = (float)target.getBoundigBox().field_72340_a - (float)(this.vehicle.field_70165_t + offset.field_72450_a);
        float targetY = (float)target.getBoundigBox().field_72338_b - (float)(this.vehicle.field_70163_u + offset.field_72448_b);
        float targetZ = (float)target.getBoundigBox().field_72339_c - (float)(this.vehicle.field_70161_v + offset.field_72449_c);
        Tuple<Float, Float> anglesMin = Trig.getLaunchAngleToHit(targetX, targetY, targetZ, this.vehicle.localLaunchPower);
        if (Math.abs(((Float)anglesMin.func_76340_b()).floatValue() - this.vehicle.localTurretPitch) < 0.35f || Math.abs(((Float)anglesMin.func_76341_a()).floatValue() - this.vehicle.localTurretPitch) < 0.35f) {
            return true;
        }
        targetX = (float)target.getBoundigBox().field_72336_d - (float)(this.vehicle.field_70165_t + offset.field_72450_a);
        targetY = (float)target.getBoundigBox().field_72337_e - (float)(this.vehicle.field_70163_u + offset.field_72448_b);
        targetZ = (float)target.getBoundigBox().field_72334_f - (float)(this.vehicle.field_70161_v + offset.field_72449_c);
        Tuple<Float, Float> anglesMax = Trig.getLaunchAngleToHit(targetX, targetY, targetZ, this.vehicle.localLaunchPower);
        if (Math.abs(((Float)anglesMax.func_76340_b()).floatValue() - this.vehicle.localTurretPitch) < 0.35f || Math.abs(((Float)anglesMax.func_76341_a()).floatValue() - this.vehicle.localTurretPitch) < 0.35f) {
            return true;
        }
        return Trig.isAngleBetween(this.vehicle.localTurretPitch, ((Float)anglesMin.func_76341_a()).floatValue(), ((Float)anglesMax.func_76341_a()).floatValue()) || Trig.isAngleBetween(this.vehicle.localTurretPitch, ((Float)anglesMin.func_76340_b()).floatValue(), ((Float)anglesMax.func_76340_b()).floatValue());
    }

    private boolean isPowerSetToPointAt(ITarget target) {
        float maxDistY;
        float minDistY;
        if (!this.vehicle.canAimPower()) {
            return true;
        }
        Vec3d offset = this.vehicle.getMissileOffset();
        float x = (float)(this.vehicle.field_70165_t + offset.field_72450_a);
        float y = (float)(this.vehicle.field_70163_u + offset.field_72448_b);
        float z = (float)(this.vehicle.field_70161_v + offset.field_72449_c);
        if (Math.abs(target.getBoundigBox().field_72338_b - (double)y) < Math.abs(target.getBoundigBox().field_72337_e - (double)y)) {
            minDistY = (float)(target.getBoundigBox().field_72338_b - (double)y);
            maxDistY = (float)(target.getBoundigBox().field_72337_e - (double)y);
        } else {
            minDistY = (float)(target.getBoundigBox().field_72337_e - (double)y);
            maxDistY = (float)(target.getBoundigBox().field_72338_b - (double)y);
        }
        float powerMin = this.getPowerFor((float)target.getBoundigBox().field_72340_a - x, minDistY, (float)target.getBoundigBox().field_72339_c - z);
        float powerMax = this.getPowerFor((float)target.getBoundigBox().field_72336_d - x, maxDistY, (float)target.getBoundigBox().field_72334_f - z);
        if (powerMin > powerMax) {
            float temp = powerMin;
            powerMin = powerMax;
            powerMax = temp;
        }
        return this.vehicle.localLaunchPower >= powerMin && this.vehicle.localLaunchPower <= powerMax;
    }

    private float getPowerFor(float distX, float distY, float distZ) {
        return Trig.iterativeSpeedFinder(distX, distY, distZ, this.vehicle.localTurretPitch + this.vehicle.field_70125_A, 20, this.vehicle.ammoHelper.getCurrentAmmoType() != null && this.vehicle.ammoHelper.getCurrentAmmoType().isRocket());
    }

    public float getAimYaw(ITarget target) {
        return this.getAimYaw(target.getX(), target.getZ());
    }
}

