/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.input;

import codechicken.lib.raytracer.RayTracer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.input.IVehicleMovementHandler;
import net.shadowmage.ancientwarfare.vehicle.input.VehicleCallback;
import net.shadowmage.ancientwarfare.vehicle.input.VehicleKeyConflictContext;
import net.shadowmage.ancientwarfare.vehicle.network.PacketVehicleInput;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class VehicleInputHandler {
    private static final String CATEGORY = "keybind.category.awVehicles";
    private static final KeyBinding FORWARD = new KeyBinding("keybind.vehicle.forward", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 17, "keybind.category.awVehicles");
    private static final KeyBinding REVERSE = new KeyBinding("keybind.vehicle.reverse", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 31, "keybind.category.awVehicles");
    private static final KeyBinding LEFT = new KeyBinding("keybind.vehicle.left", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 30, "keybind.category.awVehicles");
    private static final KeyBinding RIGHT = new KeyBinding("keybind.vehicle.right", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 32, "keybind.category.awVehicles");
    private static final KeyBinding ASCEND_AIM_UP = new KeyBinding("keybind.vehicle.ascend.aim.up", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 19, "keybind.category.awVehicles");
    private static final KeyBinding DESCEND_AIM_DOWN = new KeyBinding("keybind.vehicle.descend.aim.down", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 33, "keybind.category.awVehicles");
    private static final KeyBinding FIRE = new KeyBinding("keybind.vehicle.fire", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 57, "keybind.category.awVehicles");
    private static final KeyBinding AMMO_PREV = new KeyBinding("keybind.vehicle.ammo.prev", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 20, "keybind.category.awVehicles");
    private static final KeyBinding AMMO_NEXT = new KeyBinding("keybind.vehicle.ammo.next", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 34, "keybind.category.awVehicles");
    private static final KeyBinding TURRET_LEFT = new KeyBinding("keybind.vehicle.turret.left", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 44, "keybind.category.awVehicles");
    private static final KeyBinding TURRET_RIGHT = new KeyBinding("keybind.vehicle.turret.right", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 45, "keybind.category.awVehicles");
    private static final KeyBinding MOUSE_AIM = new KeyBinding("keybind.vehicle.mouse.aim", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 46, "keybind.category.awVehicles");
    private static final KeyBinding AMMO_SELECT = new KeyBinding("keybind.vehicle.ammo.select", (IKeyConflictContext)VehicleKeyConflictContext.INSTANCE, 47, "keybind.category.awVehicles");
    private static final Set<Integer> releaseableKeys = new HashSet<Integer>();
    private static boolean trackedKeyReleased = false;
    private static final Set<IVehicleMovementHandler> vehicleMovementHandlers = new HashSet<IVehicleMovementHandler>();
    private static final float MAX_RANGE = 140.0f;

    private VehicleInputHandler() {
    }

    public static void initKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)FORWARD);
        ClientRegistry.registerKeyBinding((KeyBinding)REVERSE);
        ClientRegistry.registerKeyBinding((KeyBinding)LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)ASCEND_AIM_UP);
        ClientRegistry.registerKeyBinding((KeyBinding)DESCEND_AIM_DOWN);
        ClientRegistry.registerKeyBinding((KeyBinding)FIRE);
        ClientRegistry.registerKeyBinding((KeyBinding)AMMO_PREV);
        ClientRegistry.registerKeyBinding((KeyBinding)AMMO_NEXT);
        ClientRegistry.registerKeyBinding((KeyBinding)TURRET_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)TURRET_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)MOUSE_AIM);
        ClientRegistry.registerKeyBinding((KeyBinding)AMMO_SELECT);
        VehicleInputHandler.initCallbacks();
        VehicleInputHandler.initReleaseableKeys();
    }

    private static void initReleaseableKeys() {
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(FORWARD, REVERSE, p -> p.setForwardInput((byte)1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(REVERSE, FORWARD, p -> p.setForwardInput((byte)-1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(RIGHT, LEFT, p -> p.setTurnInput((byte)1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(LEFT, RIGHT, p -> p.setTurnInput((byte)-1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(ASCEND_AIM_UP, DESCEND_AIM_DOWN, p -> p.setPowerInput((byte)1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(DESCEND_AIM_DOWN, ASCEND_AIM_UP, p -> p.setPowerInput((byte)-1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(TURRET_RIGHT, TURRET_LEFT, p -> p.setRotationInput((byte)1)));
        vehicleMovementHandlers.add(new IVehicleMovementHandler.Impl(TURRET_LEFT, TURRET_RIGHT, p -> p.setRotationInput((byte)-1)));
        releaseableKeys.add(FORWARD.func_151463_i());
        releaseableKeys.add(REVERSE.func_151463_i());
        releaseableKeys.add(LEFT.func_151463_i());
        releaseableKeys.add(RIGHT.func_151463_i());
        releaseableKeys.add(ASCEND_AIM_UP.func_151463_i());
        releaseableKeys.add(DESCEND_AIM_DOWN.func_151463_i());
        releaseableKeys.add(TURRET_LEFT.func_151463_i());
        releaseableKeys.add(TURRET_RIGHT.func_151463_i());
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        if (!Keyboard.getEventKeyState()) {
            VehicleInputHandler.trackReleasedKeys();
        }
    }

    private static void trackReleasedKeys() {
        int key = Keyboard.getEventKey();
        if (releaseableKeys.contains(key)) {
            trackedKeyReleased = true;
        }
    }

    private static void initCallbacks() {
        InputHandler.registerCallBack(MOUSE_AIM, () -> {
            AWVehicleStatics.clientSettings.enableMouseAim = !AWVehicleStatics.clientSettings.enableMouseAim;
        });
        InputHandler.registerCallBack(FIRE, new VehicleCallback(VehicleInputHandler::handleFireAction));
        InputHandler.registerCallBack(ASCEND_AIM_UP, new VehicleCallback(v -> v.firingHelper.handleAimKeyInput(-1.0f, 0.0f)));
        InputHandler.registerCallBack(DESCEND_AIM_DOWN, new VehicleCallback(v -> v.firingHelper.handleAimKeyInput(1.0f, 0.0f)));
        InputHandler.registerCallBack(TURRET_LEFT, new VehicleCallback(v -> v.firingHelper.handleAimKeyInput(0.0f, -1.0f)));
        InputHandler.registerCallBack(TURRET_RIGHT, new VehicleCallback(v -> v.firingHelper.handleAimKeyInput(0.0f, 1.0f)));
        InputHandler.registerCallBack(AMMO_NEXT, new VehicleCallback(v -> v.ammoHelper.setNextAmmo()));
        InputHandler.registerCallBack(AMMO_PREV, new VehicleCallback(v -> v.ammoHelper.setPreviousAmmo()));
        InputHandler.registerCallBack(AMMO_SELECT, new VehicleCallback(VehicleInputHandler::handleAmmoSelectAction));
    }

    private static void handleAmmoSelectAction(VehicleBase vehicle) {
        if (!vehicle.isAmmoLoaded()) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarevehicles.ammo.no_ammo", new Object[0]), true);
            return;
        }
        if (!vehicle.vehicleType.getValidAmmoTypes().isEmpty()) {
            NetworkHandler.INSTANCE.openGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 50, vehicle.func_145782_y());
        }
    }

    private static void handleFireAction(VehicleBase vehicle) {
        String configName = vehicle.vehicleType.getConfigName();
        if (!(vehicle.isAmmoLoaded() || configName.equals("battering_ram") || configName.equals("boat_transport") || configName.equals("chest_cart"))) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("gui.ancientwarfarevehicles.ammo.no_ammo", new Object[0]), true);
        }
        if (vehicle.isAimable()) {
            vehicle.firingHelper.handleFireInput();
        }
    }

    private static RayTraceResult getPlayerLookTargetClient(EntityPlayer player, Entity excludedEntity) {
        Vec3d playerEyesPos = RayTracer.getCorrectedHeadVec((EntityPlayer)player);
        Vec3d lookVector = player.func_70676_i(0.0f);
        Vec3d endVector = playerEyesPos.func_72441_c(lookVector.field_72450_a * 140.0, lookVector.field_72448_b * 140.0, lookVector.field_72449_c * 140.0);
        RayTraceResult blockHit = player.field_70170_p.func_72933_a(playerEyesPos, endVector);
        Optional<Tuple<Double, Entity>> closestEntityFound = VehicleInputHandler.getClosestCollidedEntity(excludedEntity, playerEyesPos, lookVector, endVector);
        if (closestEntityFound.isPresent() && (blockHit == null || (Double)closestEntityFound.get().func_76341_a() < blockHit.field_72307_f.func_72438_d(playerEyesPos))) {
            Entity hitEntity = (Entity)closestEntityFound.get().func_76340_b();
            blockHit = new RayTraceResult(hitEntity, new Vec3d(hitEntity.field_70165_t, hitEntity.field_70163_u + (double)hitEntity.field_70131_O * 0.65, hitEntity.field_70161_v));
        }
        return blockHit;
    }

    private static Optional<Tuple<Double, Entity>> getClosestCollidedEntity(Entity excludedEntity, Vec3d playerEyesPos, Vec3d lookVector, Vec3d endVector) {
        Minecraft mc = Minecraft.func_71410_x();
        List possibleHitEntities = mc.field_71441_e.func_72839_b(mc.func_175606_aa(), mc.func_175606_aa().func_174813_aQ().func_72321_a(lookVector.field_72450_a * 140.0, lookVector.field_72448_b * 140.0, lookVector.field_72449_c * 140.0).func_72314_b(1.0, 1.0, 1.0));
        return possibleHitEntities.stream().filter(e -> e != excludedEntity && e.func_70067_L()).map(e -> new Tuple((Object)VehicleInputHandler.getDistanceToCollidedEntity(e, playerEyesPos, endVector), e)).filter(t -> (Double)t.func_76341_a() < Double.MAX_VALUE).sorted(Comparator.comparing(Tuple::func_76341_a)).findFirst();
    }

    private static double getDistanceToCollidedEntity(Entity entity, Vec3d startVector, Vec3d endVector) {
        float borderSize = entity.func_70111_Y();
        AxisAlignedBB entBB = entity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        RayTraceResult rayTraceResult = entBB.func_72327_a(startVector, endVector);
        return rayTraceResult != null ? startVector.func_72438_d(rayTraceResult.field_72307_f) : Double.MAX_VALUE;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.func_184187_bx() instanceof VehicleBase) {
            VehicleBase vehicle = (VehicleBase)mc.field_71439_g.func_184187_bx();
            VehicleInputHandler.handleTickInput(vehicle);
            if (AWVehicleStatics.clientSettings.enableMouseAim) {
                this.handleMouseAimUpdate(vehicle);
            }
        }
    }

    private void handleMouseAimUpdate(VehicleBase vehicle) {
        if (vehicle.field_70173_aa % 5 == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult pos = VehicleInputHandler.getPlayerLookTargetClient((EntityPlayer)mc.field_71439_g, vehicle);
        if (pos != null) {
            vehicle.firingHelper.handleAimInput(pos.field_72307_f);
        }
    }

    private static void handleTickInput(VehicleBase vehicle) {
        if (trackedKeyReleased || vehicle.field_70173_aa % 20 == 0) {
            trackedKeyReleased = false;
            PacketVehicleInput pkt = new PacketVehicleInput(vehicle);
            vehicleMovementHandlers.stream().filter(h -> h.getKeyBinding().func_151470_d() && !h.getReverseKeyBinding().func_151470_d()).forEach(h -> h.updatePacket(pkt));
            NetworkHandler.sendToServer(pkt);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new VehicleInputHandler());
    }
}

