/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.vehicle.armors.IVehicleArmor;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.inventory.AmmoStackHandler;
import net.shadowmage.ancientwarfare.vehicle.inventory.ArmorStackHandler;
import net.shadowmage.ancientwarfare.vehicle.inventory.UpgradeStackHandler;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.VehicleAmmoEntry;
import net.shadowmage.ancientwarfare.vehicle.upgrades.IVehicleUpgradeType;

public class VehicleInventory {
    private static final String INVENTORY_TAG = "inventory";
    private VehicleBase vehicle;
    public ItemStackHandler upgradeInventory;
    public ItemStackHandler ammoInventory;
    public ItemStackHandler armorInventory;
    public ItemStackHandler storageInventory;

    public VehicleInventory(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    public void setInventorySizes(int upgrade, int ammo, int armor, int storage) {
        this.ammoInventory = new AmmoStackHandler(this.vehicle, ammo);
        this.armorInventory = new ArmorStackHandler(this.vehicle, armor);
        this.storageInventory = new ItemStackHandler(storage);
        this.upgradeInventory = new UpgradeStackHandler(this.vehicle, upgrade);
    }

    public void writeToNBT(NBTTagCompound commonTag) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.upgradeInventory != null) {
            tag.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.serializeNBT());
        }
        if (this.ammoInventory != null) {
            tag.func_74782_a("ammoInventory", (NBTBase)this.ammoInventory.serializeNBT());
        }
        if (this.storageInventory != null) {
            tag.func_74782_a("storageInventory", (NBTBase)this.storageInventory.serializeNBT());
        }
        if (this.armorInventory != null) {
            tag.func_74782_a("armorInventory", (NBTBase)this.armorInventory.serializeNBT());
        }
        commonTag.func_74782_a(INVENTORY_TAG, (NBTBase)tag);
    }

    public void readFromNBT(NBTTagCompound commonTag) {
        if (!commonTag.func_74764_b(INVENTORY_TAG)) {
            return;
        }
        NBTTagCompound tag = commonTag.func_74775_l(INVENTORY_TAG);
        if (this.upgradeInventory != null) {
            this.upgradeInventory.deserializeNBT(tag.func_74775_l("upgradeInventory"));
        }
        if (this.ammoInventory != null) {
            this.ammoInventory.deserializeNBT(tag.func_74775_l("ammoInventory"));
        }
        if (this.storageInventory != null) {
            this.storageInventory.deserializeNBT(tag.func_74775_l("storageInventory"));
        }
        if (this.armorInventory != null) {
            this.armorInventory.deserializeNBT(tag.func_74775_l("armorInventory"));
        }
    }

    public List<IVehicleArmor> getInventoryArmor() {
        ArrayList<IVehicleArmor> armors = new ArrayList<IVehicleArmor>();
        for (int i = 0; i < this.armorInventory.getSlots(); ++i) {
            ItemStack stack = this.armorInventory.getStackInSlot(i);
            ArmorRegistry.getArmorForStack(stack).ifPresent(armors::add);
        }
        return armors;
    }

    public List<IVehicleUpgradeType> getInventoryUpgrades() {
        ArrayList<IVehicleUpgradeType> upgrades = new ArrayList<IVehicleUpgradeType>();
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            ItemStack stack = this.upgradeInventory.getStackInSlot(i);
            UpgradeRegistry.getUpgrade(stack).ifPresent(upgrades::add);
        }
        return upgrades;
    }

    public List<VehicleAmmoEntry> getAmmoCounts() {
        ArrayList<VehicleAmmoEntry> counts = new ArrayList<VehicleAmmoEntry>();
        for (int i = 0; i < this.ammoInventory.getSlots(); ++i) {
            ItemStack stack = this.ammoInventory.getStackInSlot(i);
            AmmoRegistry.getAmmoForStack(stack).ifPresent(ammo -> {
                boolean found = false;
                for (VehicleAmmoEntry ent : counts) {
                    if (ent.baseAmmoType != ammo) continue;
                    found = true;
                    ent.ammoCount += stack.func_190916_E();
                    break;
                }
                if (!found) {
                    counts.add(new VehicleAmmoEntry((IAmmo)ammo));
                    ((VehicleAmmoEntry)counts.get((int)(counts.size() - 1))).ammoCount += stack.func_190916_E();
                }
            });
        }
        return counts;
    }
}

