/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.network.PacketVehicleBase;

public class PacketUpgradeUpdate
extends PacketVehicleBase {
    private String[] upgradeRegistryNames;
    private String[] armorRegistryNames;

    public PacketUpgradeUpdate() {
    }

    public PacketUpgradeUpdate(VehicleBase vehicle) {
        super(vehicle);
        this.upgradeRegistryNames = vehicle.upgradeHelper.serializeUpgrades();
        this.armorRegistryNames = vehicle.upgradeHelper.serializeInstalledArmors();
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        super.writeToStream(data);
        PacketBuffer pb = new PacketBuffer(data);
        pb.writeInt(this.upgradeRegistryNames.length);
        for (String upgrade : this.upgradeRegistryNames) {
            pb.func_180714_a(upgrade);
        }
        pb.writeInt(this.armorRegistryNames.length);
        for (String armor : this.armorRegistryNames) {
            pb.func_180714_a(armor);
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        int i;
        super.readFromStream(data);
        PacketBuffer pb = new PacketBuffer(data);
        this.upgradeRegistryNames = new String[pb.readInt()];
        for (i = 0; i < this.upgradeRegistryNames.length; ++i) {
            this.upgradeRegistryNames[i] = pb.func_150789_c(64);
        }
        this.armorRegistryNames = new String[pb.readInt()];
        for (i = 0; i < this.armorRegistryNames.length; ++i) {
            this.armorRegistryNames[i] = pb.func_150789_c(64);
        }
    }

    @Override
    public void execute() {
        this.vehicle.upgradeHelper.updateUpgrades(this.armorRegistryNames, this.upgradeRegistryNames);
    }
}

