/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathUtils;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class EntityPath {
    private LinkedList<Node> path = new LinkedList();

    public void setPath(List<Node> pathNodes) {
        this.clearPath();
        this.path.addAll(pathNodes);
    }

    public void clearPath() {
        this.path.clear();
    }

    public void addPath(PathWorldAccess world, List<Node> pathNodes) {
        Node n = null;
        Node start = null;
        if (pathNodes.size() > 0) {
            start = pathNodes.get(0);
        }
        if (start == null) {
            return;
        }
        Iterator it = this.path.iterator();
        boolean couldSee = false;
        while (it.hasNext()) {
            n = (Node)it.next();
            if (!couldSee) {
                if (!PathUtils.canPathStraightToTarget(world, n.x, n.y, n.z, start.getPos())) continue;
                couldSee = true;
                continue;
            }
            it.remove();
        }
        this.path.addAll(pathNodes);
    }

    public boolean containsPoint(int x, int y, int z) {
        for (Node n : this.path) {
            if (!n.equals(x, y, z)) continue;
            return true;
        }
        return false;
    }

    public Node getEndNode() {
        return this.path.peekLast();
    }

    public Node getFirstNode() {
        return this.path.peekFirst();
    }

    public Node claimNode() {
        return this.path.poll();
    }

    public int getActivePathSize() {
        return this.path.size();
    }

    public float getActivePathLength() {
        if (this.path.isEmpty()) {
            return 0.0f;
        }
        return this.path.get(this.path.size() - 1).getPathLength();
    }

    public List<Node> getActivePath() {
        return this.path;
    }
}

