/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class Node
implements Comparable {
    public float goalLenght;
    public float travelCost = 10.0f;
    public Node parentNode = null;
    public float g = Float.POSITIVE_INFINITY;
    public float f;
    public int x;
    public int y;
    public int z;
    public boolean obstacle = false;
    public boolean closed = false;

    public Node(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Node(int bX, int bY, int bZ) {
        this.x = bX;
        this.y = bY;
        this.z = bZ;
    }

    public Node(int x, int y, int z, Node parent, Node goal, float g) {
        this(x, y, z);
        this.parentNode = parent;
        this.g = g;
        this.f = this.getH(goal) + this.g;
    }

    public Node reassign(BlockPos pos) {
        return this.reassign(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Node reassign(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public void calcTraveCost(PathWorldAccess world, Node parentNode) {
        if (world == null) {
            return;
        }
        this.obstacle = false;
        this.travelCost = 10.0f;
        this.obstacle = !world.isWalkable(this.x, this.y, this.z, parentNode);
    }

    protected float getH(Node b) {
        return this.getDistanceFrom(b) * 10.0f + this.travelCost;
    }

    protected float getH(int tx, int ty, int tz) {
        return this.getDistanceFrom(tx, ty, tz) * 10.0f + this.travelCost;
    }

    public int compareTo(Object o) {
        if (o instanceof Node) {
            Node other = (Node)o;
            float thisVal = this.f;
            float otherVal = other.f;
            if (thisVal < otherVal) {
                return -1;
            }
            if (thisVal > otherVal) {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(Object checkagainst) {
        if (checkagainst instanceof Node) {
            Node check = (Node)checkagainst;
            if (check.x == this.x && check.y == this.y && check.z == this.z) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public float getDistanceFrom(Node node) {
        if (node == null) {
            return 0.0f;
        }
        float x = this.x - node.x;
        float y = this.y - node.y;
        float z = this.z - node.z;
        return MathHelper.func_76129_c((float)(x * x + y * y + z * z));
    }

    public float getDistanceFrom(int x, int y, int z) {
        float x1 = this.x - x;
        float y1 = this.y - y;
        float z1 = this.z - z;
        return MathHelper.func_76129_c((float)(x1 * x1 + y1 * y1 + z1 * z1));
    }

    public float getPathLength() {
        float len = 0.0f;
        if (this.parentNode != null) {
            len += this.getDistanceFrom(this.parentNode);
            len += this.parentNode.getPathLength();
        }
        return len;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public int hashCode() {
        return this.x << 16 ^ this.z ^ this.y << 24;
    }

    public String toString() {
        return "Node: " + this.x + "," + this.y + "," + this.z + " TC: " + this.travelCost + " F: " + this.f;
    }
}

