/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;

public class PathWorldAccess {
    public boolean canOpenDoors;
    public boolean canSwim;
    public boolean canDrop;
    public boolean canUseLaders;
    private boolean canGoOnLand = true;
    private World world;

    public PathWorldAccess(World world) {
        this.world = world;
    }

    public void setCanGoOnLand(boolean val) {
        this.canGoOnLand = val;
        if (!val) {
            this.canSwim = true;
        }
    }

    public Block getBlock(BlockPos pos) {
        return this.world.func_180495_p(pos).func_177230_c();
    }

    public int getTravelCost(BlockPos pos) {
        Block block = this.getBlock(pos);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            if (!this.canGoOnLand) {
                return 10;
            }
            return 30;
        }
        if (!this.canGoOnLand) {
            return 30;
        }
        return 10;
    }

    public boolean checkBlockBounds(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return true;
        }
        if (block == Blocks.field_150415_aT) {
            return (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
        }
        if (block != Blocks.field_150350_a) {
            AxisAlignedBB bb = block.func_180646_a(state, (IBlockAccess)this.world, pos);
            if (bb == null) {
                return true;
            }
            if (bb.field_72337_e >= 0.5) {
                return false;
            }
        }
        return true;
    }

    private boolean isWalkable2(int x, int y, int z) {
        boolean cube3;
        BlockPos pos = new BlockPos(x, y, z);
        Block block = this.getBlock(pos);
        Block blockDown = this.getBlock(pos.func_177977_b());
        Block blockUp = this.getBlock(pos.func_177984_a());
        boolean cube = !this.checkBlockBounds(x, y, z);
        boolean cube2 = !this.checkBlockBounds(x, y - 1, z);
        boolean bl = cube3 = !this.checkBlockBounds(x, y + 1, z);
        if (this.isFence(blockDown) || this.isDoor(pos.func_177977_b()) && this.isDoor(pos) || block == Blocks.field_150434_aF || blockDown == Blocks.field_150434_aF || blockUp == Blocks.field_150434_aF) {
            return false;
        }
        if (this.canGoOnLand) {
            if (this.canUseLaders && this.isLadder(block)) {
                return true;
            }
            if (this.canOpenDoors && this.isDoor(pos) && cube2) {
                return true;
            }
            if (!cube && !cube3 && (cube2 || this.canSupport(block, pos))) {
                return true;
            }
        }
        return this.canSwim && this.isWater(block) && blockUp == Blocks.field_150350_a;
    }

    public boolean isPartialBlock(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150350_a) {
            AxisAlignedBB bb = state.func_185890_d((IBlockAccess)this.world, pos);
            if (bb == null) {
                return false;
            }
            if (bb.field_72337_e <= 0.75 && bb.field_72340_a < 0.35 && bb.field_72336_d > 0.65 && bb.field_72339_c < 0.35 && bb.field_72334_f > 0.65) {
                return true;
            }
        }
        return false;
    }

    private boolean canSupport(Block block, BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (block == Blocks.field_150415_aT) {
            return (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) == false && state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.BOTTOM;
        }
        AxisAlignedBB bb = block.func_180646_a(state, (IBlockAccess)this.world, pos);
        return bb != null && bb.field_72337_e <= 0.5 && bb.field_72340_a < 0.35 && bb.field_72336_d > 0.65 && bb.field_72339_c < 0.35 && bb.field_72334_f > 0.65;
    }

    private boolean isFence(Block block) {
        return block instanceof BlockFence || block instanceof BlockFenceGate || block == Blocks.field_150463_bK;
    }

    public boolean isWalkable(int x, int y, int z) {
        return this.isWalkable2(x, y, z);
    }

    private boolean isWater(Block block) {
        return block == Blocks.field_150355_j || block == Blocks.field_150358_i;
    }

    public boolean isDoor(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == AWStructureBlocks.GATE_PROXY) {
            return WorldTools.getTile((IBlockAccess)this.world, pos, TEGateProxy.class).map(proxy -> proxy.getOwner().map(p -> p.getGateType().canSoldierActivate()).orElse(false)).orElse(true);
        }
        return block instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d || block instanceof BlockFenceGate;
    }

    private boolean isLadder(Block block) {
        return block == Blocks.field_150468_ap || block == Blocks.field_150395_bd;
    }

    protected boolean isLadder(BlockPos pos) {
        Block block = this.world.func_180495_p(pos).func_177230_c();
        return this.isLadder(block);
    }

    public boolean isWalkable(int x, int y, int z, Node src) {
        return this.isWalkable(x, y, z);
    }

    public boolean isRemote() {
        return false;
    }
}

