/*
 * Decompiled with CFR 0.152.
 */
package com.animania;

import com.animania.Animania;
import com.animania.capabilities.CapabilityRefs;
import com.animania.capabilities.ICapabilityPlayer;
import com.animania.entities.props.EntityCart;
import com.animania.entities.props.EntityWagon;
import com.animania.network.client.TileEntitySyncPacket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AnimaniaHelper {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static <T extends EntityLivingBase> List<T> getEntitiesInRange(Class<? extends T> filterEntity, double range, World world, Entity theEntity) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB(theEntity.field_70165_t - range, theEntity.field_70163_u - range, theEntity.field_70161_v - range, theEntity.field_70165_t + range, theEntity.field_70163_u + range, theEntity.field_70161_v + range));
        return list;
    }

    public static <T extends EntityLivingBase> List<T> getEntitiesInRange(Class<? extends T> filterEntity, double range, World world, BlockPos pos) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB((double)pos.func_177958_n() - range, (double)pos.func_177956_o() - range, (double)pos.func_177952_p() - range, (double)pos.func_177958_n() + range, (double)pos.func_177956_o() + range, (double)pos.func_177952_p() + range));
        return list;
    }

    public static <T extends EntityCart> List<T> getCartsInRange(Class<? extends T> filterEntity, double range, World world, Entity theEntity) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB(theEntity.field_70165_t - range, theEntity.field_70163_u - range, theEntity.field_70161_v - range, theEntity.field_70165_t + range, theEntity.field_70163_u + range, theEntity.field_70161_v + range));
        return list;
    }

    public static <T extends EntityWagon> List<T> getWagonsInRange(Class<? extends T> filterEntity, double range, World world, Entity theEntity) {
        List list = world.func_72872_a(filterEntity, new AxisAlignedBB(theEntity.field_70165_t - range, theEntity.field_70163_u - range, theEntity.field_70161_v - range, theEntity.field_70165_t + range, theEntity.field_70163_u + range, theEntity.field_70161_v + range));
        return list;
    }

    public static void sendTileEntityUpdate(TileEntity tile) {
        if (tile.func_145831_w() != null && !tile.func_145831_w().field_72995_K) {
            NBTTagCompound compound = new NBTTagCompound();
            compound = tile.func_189515_b(compound);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("data", (NBTBase)compound);
            data.func_74768_a("x", tile.func_174877_v().func_177958_n());
            data.func_74768_a("y", tile.func_174877_v().func_177956_o());
            data.func_74768_a("z", tile.func_174877_v().func_177952_p());
            Animania.network.sendToAllAround((IMessage)new TileEntitySyncPacket(data), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), 64.0));
        }
    }

    public static void syncCap(Entity entity, ICapabilityPlayer other) {
        ICapabilityPlayer cap = (ICapabilityPlayer)entity.getCapability(CapabilityRefs.CAPS, null);
        cap.setAnimal(other.getAnimal());
        cap.setCarrying(other.isCarrying());
        cap.setType(other.getType());
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance) {
        Vec3d vec3d = player.func_174824_e(1.0f);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static ItemStack getItem(String name) {
        Item item;
        ItemStack stack = null;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        metaLoc = name.indexOf("#");
        if (metaLoc > -1) {
            metaVal = name.substring(metaLoc);
            name = name.replace(metaVal, "");
            metaVal = metaVal.replace("#", "");
            metaFlag = true;
        }
        if ((item = Item.func_111206_d((String)name)) != null) {
            stack = metaFlag ? new ItemStack(item, 1, Integer.parseInt(metaVal)) : new ItemStack(item, 1);
        }
        return stack;
    }

    public static void addItem(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }
}

