/*
 * Decompiled with CFR 0.152.
 */
package com.animania.blocks;

import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.compat.top.providers.TOPInfoProvider;
import com.animania.entities.rodents.EntityHamster;
import com.animania.tileentities.TileEntityHamsterWheel;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockHamsterWheel
extends BlockContainer
implements TOPInfoProvider {
    private String name = "block_hamster_wheel";
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockHamsterWheel() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        this.func_149663_c("animania_" + this.name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149675_a(true);
        this.func_149711_c(1.4f);
        this.func_149752_b(3.4f);
        this.field_149783_u = true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityHamsterWheel();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)worldIn.func_175625_s(pos);
        if (!te.isRunning()) {
            List<EntityHamster> hamsters = AnimaniaHelper.getEntitiesInRange(EntityHamster.class, 3.0, worldIn, (Entity)playerIn);
            EntityHamster hamster = null;
            if (!hamsters.isEmpty()) {
                hamster = hamsters.get(0);
            }
            if (hamster != null && hamster.getIsTamed() && hamster.func_70902_q() == playerIn && hamster.getFed() && !hamster.isInBall()) {
                te.setHamster(hamster);
                te.func_70296_d();
                if (hamster.func_110167_bD()) {
                    hamster.func_110160_i(true, false);
                }
                hamster.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                hamster.func_82142_c(true);
                playerIn.func_184609_a(EnumHand.MAIN_HAND);
                Random rand = new Random();
                playerIn.func_184185_a(SoundEvents.field_187638_cR, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                return true;
            }
        } else {
            te.func_70296_d();
            te.ejectHamster();
            playerIn.func_184609_a(EnumHand.MAIN_HAND);
        }
        if (playerIn.func_184586_b(hand) != null && playerIn.func_184586_b(hand).func_77973_b() == Animania.hamsterFood) {
            ItemStack held = playerIn.func_184586_b(hand);
            ItemStack remainder = te.getItemHandler().insertItem(0, new ItemStack(Animania.hamsterFood), false);
            if (!playerIn.func_184812_l_() && remainder == null) {
                --held.field_77994_a;
            }
            return true;
        }
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && hand == EnumHand.MAIN_HAND) {
            ItemStack food = te.getItemHandler().getStackInSlot(0);
            if (food == null) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(te.getEnergy() + "/" + te.getPower().getMaxEnergyStored() + " RF"));
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentString(te.getEnergy() + "/" + te.getPower().getMaxEnergyStored() + " RF, " + food.field_77994_a + " " + food.func_82833_r()));
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)worldIn.func_175625_s(pos);
        if (te != null) {
            te.ejectHamster();
            if (te.getItemHandler().getStackInSlot(0) != null) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getItemHandler().getStackInSlot(0));
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityHamsterWheel wheel;
        ItemStack food;
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityHamsterWheel && mode == ProbeMode.NORMAL && (food = (wheel = (TileEntityHamsterWheel)te).getItemHandler().getStackInSlot(0)) != null) {
            probeInfo.item(food);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public String getName() {
        return this.name;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityHamsterWheel te = (TileEntityHamsterWheel)worldIn.func_175625_s(pos);
        if (te.getHamster() != null) {
            return 15;
        }
        return 0;
    }
}

