/*
 * Decompiled with CFR 0.152.
 */
package com.animania.blocks;

import com.animania.Animania;
import com.animania.blocks.AnimaniaBlock;
import com.animania.items.ItemSaltLick;
import com.animania.tileentities.TileEntitySaltLick;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockSaltLick
extends AnimaniaBlock
implements ITileEntityProvider {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125);
    private String name = "salt_lick";

    public BlockSaltLick() {
        super("salt_lick", Material.field_151576_e, MapColor.field_151666_j, false);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149711_c(1.2f);
        this.func_149752_b(1.7f);
        this.field_149758_A = true;
        GameRegistry.register((IForgeRegistryEntry)new ItemSaltLick(this), (ResourceLocation)new ResourceLocation("animania", "salt_lick"));
    }

    public void useSaltLick(World world, BlockPos pos, @Nullable EntityLivingBase entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySaltLick) {
            ((TileEntitySaltLick)te).useSaltLick();
            if (entity != null) {
                entity.func_70691_i(2.0f);
            }
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (te != null && te instanceof TileEntitySaltLick) {
            int left = ((TileEntitySaltLick)te).usesLeft;
            int damage = Animania.saltLickMaxUses - left;
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, damage));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int left = Animania.saltLickMaxUses - stack.func_77952_i();
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySaltLick) {
            ((TileEntitySaltLick)te).usesLeft = left;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntitySaltLick te;
        if (world != null && (te = (TileEntitySaltLick)world.func_175625_s(pos)) != null) {
            double usesLeft = (double)te.usesLeft / (double)Animania.saltLickMaxUses;
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625 * usesLeft, 0.8125);
        }
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntitySaltLick te;
        if (worldIn != null && (te = (TileEntitySaltLick)worldIn.func_175625_s(pos)) != null) {
            double usesLeft = (double)te.usesLeft / (double)Animania.saltLickMaxUses;
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625 * usesLeft, 0.8125);
        }
        return AABB;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149716_u() {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySaltLick();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public String getName() {
        return this.name;
    }
}

