/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.amphibians;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAmphibian
extends EntityAnimal {
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAmphibian.class, (DataSerializer)DataSerializers.field_187192_b);
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private boolean canEntityJump;
    private int currentMoveTypeDuration;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;

    public EntityAmphibian(World worldIn) {
        super(worldIn);
    }

    public EntityAmphibian(World worldIn, boolean canEntityJumpIn) {
        this(worldIn);
        this.func_70105_a(0.3f, 0.3f);
        this.setMovementSpeed(0.0);
        this.field_70767_i = new FrogJumpHelper(this);
        this.field_70765_h = new FrogMoveHelper(this);
        this.canEntityJump = canEntityJumpIn;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(this, 2.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 6.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_70060_a(0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float setJumpCompletion(float p_175521_1_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_175521_1_) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAnimalAge(compound.func_74762_e("Age"));
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        if (this.canEntityJump) {
            if (this.currentMoveTypeDuration > 0) {
                --this.currentMoveTypeDuration;
            }
            if (this.field_70122_E) {
                FrogJumpHelper jumphelper;
                if (!this.wasOnGround) {
                    this.func_70637_d(false);
                    this.checkLandingDelay();
                }
                if (!(jumphelper = (FrogJumpHelper)this.field_70767_i).getIsJumping()) {
                    if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                        Path path = this.field_70699_by.func_75505_d();
                        Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                        if (path != null && path.func_75873_e() < path.func_75874_d()) {
                            vec3d = path.func_75878_a((Entity)this);
                        }
                        this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                        this.startJumping();
                    }
                } else if (!jumphelper.canJump()) {
                    this.enableJumpControl();
                }
            }
            this.wasOnGround = this.field_70122_E;
        }
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((FrogJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((FrogJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.canEntityJump) {
            if (this.jumpTicks != this.jumpDuration) {
                ++this.jumpTicks;
            } else if (this.jumpDuration != 0) {
                this.jumpTicks = 0;
                this.jumpDuration = 0;
                this.func_70637_d(false);
            }
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70636_d();
        if (this.field_70122_E) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E) {
            this.squishAmount = 0.5f;
        }
        this.alterSquishAmount();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent getJumpSound() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    public EntityAmphibian createChild(EntityAgeable ageable) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.jumpDuration = 3;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int typeData;

        public RabbitTypeData(int type) {
            this.typeData = type;
        }
    }

    static class FrogMoveHelper
    extends EntityMoveHelper {
        private final EntityAmphibian theEntity;
        private double nextJumpSpeed;

        public FrogMoveHelper(EntityAmphibian rabbit) {
            super((EntityLiving)rabbit);
            this.theEntity = rabbit;
        }

        public void func_75641_c() {
            if (this.theEntity.field_70122_E && !this.theEntity.field_70703_bu && !((FrogJumpHelper)this.theEntity.field_70767_i).getIsJumping()) {
                this.theEntity.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.theEntity.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.theEntity.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                Random rand = new Random();
                float distance = rand.nextFloat() / 25.0f;
                this.nextJumpSpeed = speedIn + (double)distance;
            }
        }
    }

    public class FrogJumpHelper
    extends EntityJumpHelper {
        private final EntityAmphibian theEntity;
        private boolean canJump;

        public FrogJumpHelper(EntityAmphibian rabbit) {
            super((EntityLiving)rabbit);
            this.theEntity = rabbit;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.theEntity.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        private final EntityAmphibian theEntity;

        public AIPanic(EntityAmphibian amphibian, double speedIn) {
            super((EntityCreature)amphibian, speedIn);
            this.theEntity = amphibian;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.theEntity.setMovementSpeed(this.field_75265_b);
        }
    }
}

