/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.chickens;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.chickens.ChickenType;
import com.animania.entities.chickens.ai.EntityAIFindFood;
import com.animania.entities.chickens.ai.EntityAIFindWater;
import com.animania.entities.chickens.ai.EntityAIPanicChickens;
import com.animania.entities.chickens.ai.EntityAISwimmingChicks;
import com.animania.entities.chickens.ai.EntityAIWanderChickens;
import com.animania.entities.chickens.ai.EntityAIWatchClosestFromSide;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAnimaniaChicken
extends EntityChicken {
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public boolean field_152118_bv;
    protected ResourceLocation resourceLocation;
    protected ResourceLocation resourceLocationBlink;
    public float field_70883_f;
    public float field_70884_g;
    public float field_70888_h;
    public float field_70889_i = 1.0f;
    protected int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    public int blinkTimer;
    private int featherTimer;
    protected int damageTimer;
    protected ChickenType type;
    protected Item dropRaw = Items.field_151076_bf;
    protected Item dropCooked = Items.field_151077_bg;
    protected Item oldDropRaw = Items.field_151076_bf;
    protected Item oldDropCooked = Items.field_151077_bg;

    public EntityAnimaniaChicken(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingChicks((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicChickens((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        if (!Animania.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderChickens((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.featherTimer = Animania.featherTimer + this.field_70146_Z.nextInt(1000);
        this.func_110163_bv();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        player.func_71064_a(this.type.getAchievement(), 1);
        if (player.func_189102_a(AnimaniaAchievements.Leghorn) && player.func_189102_a(AnimaniaAchievements.Orpington) && player.func_189102_a(AnimaniaAchievements.PlymouthRock) && player.func_189102_a(AnimaniaAchievements.RhodeIslandRed) && player.func_189102_a(AnimaniaAchievements.Wyandotte)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Chickens, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsChickenJockey", this.field_152118_bv);
        nbttagcompound.func_74757_a("Fed", this.getFed());
        nbttagcompound.func_74757_a("Watered", this.getWatered());
        nbttagcompound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.field_152118_bv = nbttagcompound.func_74767_n("IsChickenJockey");
        this.setFed(nbttagcompound.func_74767_n("Fed"));
        this.setWatered(nbttagcompound.func_74767_n("Watered"));
        this.setAnimalAge(nbttagcompound.func_74762_e("Age"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        this.field_70888_h = this.field_70886_e;
        this.field_70884_g = this.field_70883_f;
        this.field_70883_f = (float)((double)this.field_70883_f + (double)(this.field_70122_E || this.func_184218_aH() ? -1 : 4) * 0.3);
        this.field_70883_f = MathHelper.func_76131_a((float)this.field_70883_f, (float)0.0f, (float)1.0f);
        this.field_70143_R = 0.0f;
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && Animania.chickensDropFeathers && !this.func_152116_bZ() && --this.featherTimer <= 0) {
            this.func_184185_a(ModSoundEvents.chickenCluck2, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_145779_a(Items.field_151008_G, 1);
            this.featherTimer = Animania.featherTimer + this.field_70146_Z.nextInt(1000);
        }
        if (!this.field_70122_E && !this.func_184218_aH() && this.field_70889_i < 1.0f) {
            this.field_70889_i = 1.0f;
        }
        this.field_70889_i = (float)((double)this.field_70889_i * 0.9);
        if (!this.field_70122_E && !this.func_184218_aH() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.field_70886_e += this.field_70889_i * 2.0f;
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void fall(float p_70069_1_) {
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.chickenCluck1;
        }
        if (chooser == 1) {
            return ModSoundEvents.chickenCluck2;
        }
        if (chooser == 2) {
            return ModSoundEvents.chickenCluck3;
        }
        if (chooser == 3) {
            return ModSoundEvents.chickenCluck4;
        }
        if (chooser == 4) {
            return ModSoundEvents.chickenCluck5;
        }
        return ModSoundEvents.chickenCluck6;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.1f, 1.4f);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.func_152116_bZ() ? 10 : super.func_70693_a(player);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean func_152116_bZ() {
        return this.field_152118_bv;
    }

    public void func_152117_i(boolean jockey) {
        this.field_152118_bv = jockey;
    }

    public EntityChicken func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected Item func_146068_u() {
        return Items.field_151008_G;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        this.func_70628_a(wasRecentlyHit, lootingModifier);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.chickenDrop;
            dropItem = AnimaniaHelper.getItem(drop);
            if (this.func_70027_ad() && drop.equals(this.dropRaw.getRegistryName().toString())) {
                drop = this.dropCooked.getRegistryName().toString();
                dropItem = AnimaniaHelper.getItem(drop);
            }
        } else if (Animania.oldMeatDrops) {
            dropItem = new ItemStack(this.oldDropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.oldDropCooked, 1);
            }
        } else {
            dropItem = new ItemStack(this.dropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.dropCooked, 1);
            }
        }
        String drop2 = Animania.chickenDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.chickenDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1) {
            if (this.func_70027_ad()) {
                if (dropItem != null) {
                    this.func_145779_a(Items.field_151077_bg, 1 + lootlevel);
                }
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.chickenDrop2Amount + lootlevel);
                }
            } else {
                if (dropItem != null) {
                    this.func_145779_a(Items.field_151076_bf, 1 + lootlevel);
                }
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.chickenDrop2Amount + lootlevel);
                }
            }
        } else if (happyDrops == 0 && dropItem2 != null) {
            this.func_145779_a(dropItem2.func_77973_b(), Animania.chickenDrop2Amount + lootlevel);
        }
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

