/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.AnimaniaAchievements;
import com.animania.entities.AnimaniaType;
import com.animania.entities.cows.EntityBullAngus;
import com.animania.entities.cows.EntityBullBase;
import com.animania.entities.cows.EntityBullFriesian;
import com.animania.entities.cows.EntityBullHereford;
import com.animania.entities.cows.EntityBullHolstein;
import com.animania.entities.cows.EntityBullLonghorn;
import com.animania.entities.cows.EntityCalfAngus;
import com.animania.entities.cows.EntityCalfBase;
import com.animania.entities.cows.EntityCalfFriesian;
import com.animania.entities.cows.EntityCalfHereford;
import com.animania.entities.cows.EntityCalfHolstein;
import com.animania.entities.cows.EntityCalfLonghorn;
import com.animania.entities.cows.EntityCowAngus;
import com.animania.entities.cows.EntityCowBase;
import com.animania.entities.cows.EntityCowFriesian;
import com.animania.entities.cows.EntityCowHereford;
import com.animania.entities.cows.EntityCowHolstein;
import com.animania.entities.cows.EntityCowLonghorn;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public enum CowType implements AnimaniaType
{
    ANGUS(EntityBullAngus.class, EntityCowAngus.class, EntityCalfAngus.class, (StatBase)AnimaniaAchievements.Angus),
    FRIESIAN(EntityBullFriesian.class, EntityCowFriesian.class, EntityCalfFriesian.class, (StatBase)AnimaniaAchievements.Friesian),
    HEREFORD(EntityBullHereford.class, EntityCowHereford.class, EntityCalfHereford.class, (StatBase)AnimaniaAchievements.Hereford),
    HOLSTEIN(EntityBullHolstein.class, EntityCowHolstein.class, EntityCalfHolstein.class, (StatBase)AnimaniaAchievements.Holstein),
    LONGHORN(EntityBullLonghorn.class, EntityCowLonghorn.class, EntityCalfLonghorn.class, (StatBase)AnimaniaAchievements.Longhorn);

    private Class bull;
    private Class cow;
    private Class calf;
    private StatBase achievement;

    private CowType(Class bull, Class cow, Class calf, StatBase achievement) {
        this.bull = bull;
        this.cow = cow;
        this.calf = calf;
        this.achievement = achievement;
    }

    public void setAchievement(StatBase achievement) {
        this.achievement = achievement;
    }

    public EntityBullBase getMale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.bull.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityBullBase bull = null;
        try {
            bull = (EntityBullBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return bull;
    }

    public EntityCowBase getFemale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.cow.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityCowBase cow = null;
        try {
            cow = (EntityCowBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return cow;
    }

    public EntityCalfBase getChild(World world) {
        Constructor constructor = null;
        try {
            constructor = this.calf.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityCalfBase calf = null;
        try {
            calf = (EntityCalfBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return calf;
    }

    public static CowType breed(CowType male, CowType female) {
        Random rand = new Random();
        if (rand.nextInt(2) == 0) {
            return male;
        }
        return female;
    }

    public StatBase getAchievement() {
        return this.achievement;
    }
}

