/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.EntityGender;
import com.animania.entities.cows.CowType;
import com.animania.entities.cows.EntityBullBase;
import com.animania.entities.cows.ai.EntityAICowEatGrass;
import com.animania.entities.cows.ai.EntityAIFindFood;
import com.animania.entities.cows.ai.EntityAIFindSaltLickCows;
import com.animania.entities.cows.ai.EntityAIFindWater;
import com.animania.entities.cows.ai.EntityAISwimmingCows;
import com.animania.entities.cows.ai.EntityAIWanderCow;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaCow
extends EntityCow {
    protected static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O});
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaCow.class, (DataSerializer)DataSerializers.field_187203_m);
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public EntityAICowEatGrass entityAIEatGrass;
    public CowType cowType;
    protected Item dropRaw = Items.field_151082_bd;
    protected Item dropCooked = Items.field_151083_be;
    protected Item oldDropRaw = Items.field_151082_bd;
    protected Item oldDropCooked = Items.field_151083_be;
    protected boolean mateable = false;
    public EntityGender gender;
    public CowType type;

    public EntityAnimaniaCow(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.entityAIEatGrass = new EntityAICowEatGrass((EntityLiving)this);
        if (!Animania.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.1));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderCow((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimmingCows((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIFindSaltLickCows((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityPlayer.class}));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Nullable
    public UUID getMateUniqueId() {
        if (this.mateable) {
            try {
                UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        EntityBullBase ebb;
        if (this instanceof EntityBullBase && (ebb = (EntityBullBase)this).getFighting()) {
            return;
        }
        this.setFed(true);
        this.setHandFed(true);
        this.entityAIEatGrass.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a(this.cowType.getAchievement(), 1);
        if (player.func_189102_a(AnimaniaAchievements.Angus) && player.func_189102_a(AnimaniaAchievements.Friesian) && player.func_189102_a(AnimaniaAchievements.Hereford) && player.func_189102_a(AnimaniaAchievements.Holstein) && player.func_189102_a(AnimaniaAchievements.Longhorn)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Cows, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70636_d() {
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        EntityBullBase ebb;
        EntityPlayer entityplayer = player;
        boolean fighting = false;
        if (this instanceof EntityBullBase && (ebb = (EntityBullBase)this).getFighting()) {
            fighting = true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151131_as && !fighting) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.entityAIEatGrass.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151133_ar) {
            return false;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != null && this.isCowBreedingItem(stack.func_77973_b());
    }

    private boolean isCowBreedingItem(Item itemIn) {
        return itemIn == Items.field_151015_O || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        UUID mate = this.getMateUniqueId();
        if (mate != null && this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setMateUniqueId(UUID.fromString(s));
        }
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setAnimalAge(compound.func_74762_e("Age"));
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.cowDrop;
            dropItem = AnimaniaHelper.getItem(drop);
            if (this.func_70027_ad() && drop.equals(this.dropRaw.getRegistryName().toString())) {
                drop = this.dropCooked.getRegistryName().toString();
                dropItem = AnimaniaHelper.getItem(drop);
            }
        } else if (Animania.oldMeatDrops) {
            dropItem = new ItemStack(this.oldDropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.oldDropCooked, 1);
            }
        } else {
            dropItem = new ItemStack(this.dropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.dropCooked, 1);
            }
        }
        String drop2 = Animania.cowDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.cowDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1) {
            if (this.func_70027_ad()) {
                if (dropItem != null) {
                    this.func_145779_a(Items.field_151083_be, 1 + lootlevel);
                }
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.cowDrop2Amount + lootlevel);
                }
            } else {
                if (dropItem != null) {
                    this.func_145779_a(Items.field_151082_bd, 1 + lootlevel);
                }
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.cowDrop2Amount + lootlevel);
                }
            }
        } else if (happyDrops == 0 && dropItem2 != null) {
            this.func_145779_a(dropItem2.func_77973_b(), Animania.cowDrop2Amount + lootlevel);
        }
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

