/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.Animania;
import com.animania.ModSoundEvents;
import com.animania.compat.top.providers.entity.TOPInfoProviderChild;
import com.animania.entities.cows.CowType;
import com.animania.entities.cows.EntityAnimaniaCow;
import com.animania.entities.cows.EntityBullBase;
import com.animania.entities.cows.EntityCowBase;
import com.animania.entities.cows.ai.EntityAIFollowParentCows;
import com.animania.entities.cows.ai.EntityAIPanicCows;
import com.google.common.base.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCalfBase
extends EntityAnimaniaCow
implements TOPInfoProviderChild {
    protected static final DataParameter<Optional<UUID>> PARENT_UNIQUE_ID = EntityDataManager.func_187226_a(EntityCalfBase.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityCalfBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int ageTimer;

    public EntityCalfBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 3.2f);
        this.field_70138_W = 1.1f;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowParentCows((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicCows((EntityCreature)this, 2.0));
        this.ageTimer = 0;
        this.cowType = CowType.FRIESIAN;
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARENT_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26000000298023224);
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Age", this.getEntityAge());
        if (this.getParentUniqueId() != null && this.getParentUniqueId() != null) {
            compound.func_74778_a("ParentUUID", this.getParentUniqueId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setEntityAge(compound.func_74760_g("Age"));
        if (compound.func_150297_b("ParentUUID", 8)) {
            s = compound.func_74779_i("ParentUUID");
        } else {
            String s1 = compound.func_74779_i("Parent");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setParentUniqueId(UUID.fromString(s));
        }
    }

    @Nullable
    public UUID getParentUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(PARENT_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParentUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public float getEntityAge() {
        try {
            return this.getFloatFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        if (chooser == 2) {
            return ModSoundEvents.mooCalf3;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        return ModSoundEvents.mooCalf3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        return ModSoundEvents.mooCalf3;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.05f, 1.1f);
    }

    @Override
    protected Item func_146068_u() {
        return null;
    }

    @Override
    public void func_70636_d() {
        this.field_175504_a = -24000;
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        ++this.ageTimer;
        if (this.ageTimer >= Animania.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            this.func_70105_a(1.2f + age, 1.8f + age);
            if ((double)age >= 0.85 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    EntityCowBase entityCow = this.cowType.getFemale(this.field_70170_p);
                    if (entityCow != null) {
                        entityCow.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityCow.func_96094_a(name);
                        }
                        entityCow.setAnimalAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityCow);
                        this.func_184185_a(ModSoundEvents.moo1, 0.5f, 1.1f);
                    }
                } else {
                    EntityBullBase entityBull = this.cowType.getMale(this.field_70170_p);
                    if (entityBull != null) {
                        entityBull.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityBull.func_96094_a(name);
                        }
                        entityBull.setAnimalAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityBull);
                        this.func_184185_a(ModSoundEvents.bullMoo1, 0.5f, 1.1f);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70628_a(boolean damaged, int looting) {
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() + 0.2f - this.getEntityAge() * 2.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 64.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && this.isCowBreedingItem(stack.func_77973_b());
    }

    private boolean isCowBreedingItem(Item itemIn) {
        return itemIn == Items.field_151015_O || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public EntityCalfBase createChild(EntityAgeable e) {
        return null;
    }
}

