/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.entities.cows.CowType;
import com.animania.entities.cows.EntityAnimaniaCow;
import com.animania.entities.cows.EntityBullBase;
import com.animania.entities.cows.EntityCalfBase;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCowBase
extends EntityAnimaniaCow
implements TOPInfoProviderMateable {
    public int dryTimerCow;
    protected ItemStack milk = new ItemStack(Items.field_151117_aB);
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityCowBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 1.8f);
        this.field_70138_W = 1.1f;
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, true));
        this.field_70715_bh.func_75776_a(9, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.mateable = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(Animania.gestationTimer + this.field_70146_Z.nextInt(200)));
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pregnant", this.getPregnant());
        compound.func_74757_a("HasKids", this.getHasKids());
        compound.func_74757_a("Fertile", this.getFertile());
        compound.func_74768_a("Gestation", this.getGestation());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setHasKids(compound.func_74767_n("HasKids"));
        this.setFertile(compound.func_74767_n("Fertile"));
        this.setGestation(compound.func_74762_e("Gestation"));
    }

    public int getGestation() {
        try {
            return this.getIntFromDataManager(GESTATION_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    public boolean getPregnant() {
        try {
            return this.getBoolFromDataManager(PREGNANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(Animania.gestationTimer + this.field_70146_Z.nextInt(500));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    public boolean getFertile() {
        try {
            return this.getBoolFromDataManager(FERTILE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFertile(boolean preggers) {
        this.field_70180_af.func_187227_b(FERTILE, (Object)preggers);
    }

    public boolean getHasKids() {
        try {
            return this.getBoolFromDataManager(HAS_KIDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHasKids(boolean kids) {
        this.field_70180_af.func_187227_b(HAS_KIDS, (Object)kids);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaCow)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= Animania.spawnLimitCows) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityBullBase entityCow = this.cowType.getMale(this.field_70170_p);
                entityCow.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityCow);
                entityCow.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityCow.getPersistentID());
            } else if (chooser == 1 && !Animania.manualBreeding) {
                EntityCalfBase entityCow = this.cowType.getChild(this.field_70170_p);
                entityCow.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityCow);
                entityCow.setParentUniqueId(this.field_96093_i);
                this.setHasKids(true);
            } else if (chooser > 2) {
                EntityBullBase entityCow = this.cowType.getMale(this.field_70170_p);
                entityCow.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityCow);
                entityCow.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityCow.getPersistentID());
                if (!Animania.manualBreeding) {
                    EntityCalfBase entityCalf = this.cowType.getChild(this.field_70170_p);
                    entityCalf.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityCalf);
                    entityCalf.setParentUniqueId(this.field_96093_i);
                    this.setHasKids(true);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = false;
        if (this.func_70685_l(entityIn) && this.func_70032_d(entityIn) <= 2.0f) {
            flag = entityIn.func_70097_a(Animania.bullDamage, 2.0f);
            if (flag) {
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
            if (entityIn instanceof EntityPlayer) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, (this.field_70165_t - entityIn.field_70165_t) / 4.0, (this.field_70161_v - entityIn.field_70161_v) / 4.0);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 16 : (happy == 1 ? 32 : 60))) == 0) {
            return ModSoundEvents.moo1;
        }
        if (chooser == 1) {
            return ModSoundEvents.moo3;
        }
        if (chooser == 2) {
            return ModSoundEvents.moo4;
        }
        if (chooser == 3) {
            return ModSoundEvents.moo4;
        }
        if (chooser == 4) {
            return ModSoundEvents.moo5;
        }
        if (chooser == 5) {
            return ModSoundEvents.moo6;
        }
        if (chooser == 6) {
            return ModSoundEvents.moo7;
        }
        if (chooser == 7) {
            return ModSoundEvents.moo8;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.cowHurt1;
        }
        return ModSoundEvents.cowHurt2;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.cowDeath1;
        }
        return ModSoundEvents.cowDeath2;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.1f, 1.0f);
    }

    @Override
    public void func_70636_d() {
        int gestationTimer;
        if (!this.getFertile() && this.dryTimerCow > -1) {
            --this.dryTimerCow;
        } else {
            this.setFertile(true);
            this.dryTimerCow = Animania.gestationTimer / 5 + this.field_70146_Z.nextInt(50);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityBullBase> entities = AnimaniaHelper.getEntitiesInRange(EntityBullBase.class, 20.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        if ((gestationTimer = this.getGestation()) > -1 && this.getPregnant()) {
            this.setGestation(--gestationTimer);
            if (gestationTimer == 0) {
                List list = this.field_70170_p.field_72996_f;
                int cowCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaCow)) continue;
                    ++num;
                }
                cowCount = num;
                UUID MateID = this.getMateUniqueId();
                List<EntityBullBase> entities = AnimaniaHelper.getEntitiesInRange(EntityBullBase.class, 30.0, this.field_70170_p, (Entity)this);
                int esize = entities.size();
                Boolean mateFound = false;
                for (int k = 0; k <= esize - 1; ++k) {
                    EntityBullBase entity = entities.get(k);
                    if (entity == null || !this.getFed() || !this.getWatered() || !entity.getPersistentID().equals(MateID)) continue;
                    this.func_146082_f(null);
                    CowType maleType = entity.cowType;
                    CowType babyType = CowType.breed(maleType, this.cowType);
                    EntityCalfBase entityCalf = babyType.getChild(this.field_70170_p);
                    entityCalf.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityCalf);
                    }
                    entityCalf.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.mooCalf1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entity, (EntityAgeable)entityCalf);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    k = esize;
                    mateFound = true;
                    break;
                }
                if (!mateFound.booleanValue() && this.getFed() && this.getWatered()) {
                    this.func_146082_f(null);
                    CowType babyType = CowType.breed(this.cowType, this.cowType);
                    EntityCalfBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.mooCalf1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entityKid, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    mateFound = true;
                }
            }
        } else if (gestationTimer < 0) {
            this.setGestation(1);
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        EntityPlayer entityplayer = player;
        if (this.getFed() && this.getWatered() && stack != null && stack.func_77973_b() == Items.field_151133_ar && this.getMateUniqueId() != null) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                player.func_184611_a(hand, this.milk.func_77946_l());
            } else if (!player.field_71071_by.func_70441_a(this.milk.func_77946_l())) {
                player.func_71019_a(this.milk.func_77946_l(), false);
            }
            this.setWatered(false);
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.entityAIEatGrass.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 64.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityCowBase createChild(EntityAgeable ageable) {
        return null;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getHasKids()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.milkable"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

