/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.goats;

import com.animania.entities.AnimaniaType;
import com.animania.entities.goats.EntityBuckAlpine;
import com.animania.entities.goats.EntityBuckAngora;
import com.animania.entities.goats.EntityBuckBase;
import com.animania.entities.goats.EntityBuckFainting;
import com.animania.entities.goats.EntityBuckKiko;
import com.animania.entities.goats.EntityBuckKinder;
import com.animania.entities.goats.EntityBuckNigerianDwarf;
import com.animania.entities.goats.EntityBuckPygmy;
import com.animania.entities.goats.EntityDoeAlpine;
import com.animania.entities.goats.EntityDoeAngora;
import com.animania.entities.goats.EntityDoeBase;
import com.animania.entities.goats.EntityDoeFainting;
import com.animania.entities.goats.EntityDoeKiko;
import com.animania.entities.goats.EntityDoeKinder;
import com.animania.entities.goats.EntityDoeNigerianDwarf;
import com.animania.entities.goats.EntityDoePygmy;
import com.animania.entities.goats.EntityKidAlpine;
import com.animania.entities.goats.EntityKidAngora;
import com.animania.entities.goats.EntityKidBase;
import com.animania.entities.goats.EntityKidFainting;
import com.animania.entities.goats.EntityKidKiko;
import com.animania.entities.goats.EntityKidKinder;
import com.animania.entities.goats.EntityKidNigerianDwarf;
import com.animania.entities.goats.EntityKidPygmy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public enum GoatType implements AnimaniaType
{
    ALPINE(EntityBuckAlpine.class, EntityDoeAlpine.class, EntityKidAlpine.class),
    ANGORA(EntityBuckAngora.class, EntityDoeAngora.class, EntityKidAngora.class),
    FAINTING(EntityBuckFainting.class, EntityDoeFainting.class, EntityKidFainting.class),
    KIKO(EntityBuckKiko.class, EntityDoeKiko.class, EntityKidKiko.class),
    KINDER(EntityBuckKinder.class, EntityDoeKinder.class, EntityKidKinder.class),
    NIGERIAN_DWARF(EntityBuckNigerianDwarf.class, EntityDoeNigerianDwarf.class, EntityKidNigerianDwarf.class),
    PYGMY(EntityBuckPygmy.class, EntityDoePygmy.class, EntityKidPygmy.class);

    private Class male;
    private Class female;
    private Class child;
    private StatBase achievement;

    private GoatType(Class male, Class female, Class child) {
        this.male = male;
        this.female = female;
        this.child = child;
    }

    public void setAchievement(StatBase achievement) {
        this.achievement = achievement;
    }

    public EntityBuckBase getMale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.male.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityBuckBase male = null;
        try {
            male = (EntityBuckBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return male;
    }

    public EntityDoeBase getFemale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.female.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityDoeBase female = null;
        try {
            female = (EntityDoeBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return female;
    }

    public EntityKidBase getChild(World world) {
        Constructor constructor = null;
        try {
            constructor = this.child.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityKidBase child = null;
        try {
            child = (EntityKidBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return child;
    }

    public static GoatType breed(GoatType male, GoatType female) {
        Random rand = new Random();
        if (rand.nextInt(2) == 0) {
            return male;
        }
        return female;
    }

    public StatBase getAchievement() {
        return this.achievement;
    }
}

