/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.horses;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.horses.EntityHorseEatGrass;
import com.animania.entities.horses.HorseType;
import com.animania.entities.horses.ai.EntityAIFindFood;
import com.animania.entities.horses.ai.EntityAIFindSaltLickHorses;
import com.animania.entities.horses.ai.EntityAIFindWater;
import com.animania.entities.horses.ai.EntityAIFollowMateHorses;
import com.animania.entities.horses.ai.EntityAIMateHorses;
import com.animania.entities.horses.ai.EntityAIPanicHorses;
import com.animania.entities.horses.ai.EntityAISwimmingHorse;
import com.animania.entities.horses.ai.EntityAITemptHorses;
import com.animania.entities.horses.ai.EntityAIWanderHorse;
import com.animania.entities.props.EntityWagon;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaHorse
extends EntityHorse
implements IJumpingMount {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O, Items.field_151034_e, Items.field_151172_bF});
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String[] HORSE_TEXTURES = new String[]{"black", "bw1", "bw2", "grey", "red", "white"};
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public EntityHorseEatGrass entityAIEatGrass;
    public HorseType horseType;
    protected boolean mateable = false;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    protected Item dropRaw = Item.func_150898_a((Block)Blocks.field_150350_a);
    protected Item dropCooked = Item.func_150898_a((Block)Blocks.field_150350_a);

    public EntityAnimaniaHorse(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.1f;
        this.field_70714_bg.field_75782_a.clear();
        this.entityAIEatGrass = new EntityHorseEatGrass((EntityLiving)this);
        if (!Animania.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicHorses((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMateHorses((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowMateHorses((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderHorse((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimmingHorse((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITemptHorses((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIFindSaltLickHorses((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_70701_bs * 4.0f;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd()) {
                strafe = 0.0f;
                forward = 0.0f;
            }
            if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                this.field_70181_x = this.func_110215_cj() * (double)this.field_110277_bt;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.func_110255_k(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.field_110277_bt);
                    this.field_70179_y += (double)(0.4f * f1 * this.field_110277_bt);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.field_110277_bt = 0.0f;
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.field_110277_bt = 0.0f;
                this.func_110255_k(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            forward = this.field_70701_bs;
            super.func_70612_e(strafe, forward);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        this.field_110277_bt = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    @Nullable
    public UUID getMateUniqueId() {
        if (this.mateable) {
            try {
                UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.setHandFed(true);
        this.entityAIEatGrass.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a(this.horseType.getAchievement(), 1);
        player.func_71064_a((StatBase)AnimaniaAchievements.Horses, 1);
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int getColorNumber() {
        try {
            return this.getIntFromDataManager(COLOR_NUM);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    protected ItemStack getItem(String moditem) {
        Item bob;
        ItemStack foundStack = null;
        String item = "";
        String mod = "";
        int sepLoc = 0;
        int metaLoc = 0;
        boolean metaFlag = false;
        String metaVal = "";
        sepLoc = moditem.indexOf(":");
        metaLoc = moditem.indexOf("#");
        if (!moditem.contains(":")) {
            return new ItemStack(Blocks.field_150350_a, 1);
        }
        mod = moditem.substring(0, sepLoc);
        item = metaLoc > 0 ? moditem.substring(sepLoc + 1, metaLoc) : moditem;
        if (metaLoc > 0) {
            metaFlag = true;
            metaVal = moditem.substring(metaLoc + 1, moditem.length());
        }
        foundStack = (bob = Item.func_111206_d((String)item)) != null ? (metaFlag ? new ItemStack(bob, 1, Integer.parseInt(metaVal)) : new ItemStack(bob, 1)) : new ItemStack(Blocks.field_150350_a, 1);
        return foundStack;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (passenger instanceof EntityPlayer) {
                f1 = (float)((this.field_70128_L ? (double)0.01f : 1.6) + passenger.func_70033_W());
            }
            if (passenger instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)passenger;
                List<EntityWagon> wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.field_70170_p, (Entity)this);
                if (!wagons.isEmpty()) {
                    if (wagons.size() >= 0) {
                        for (int i = 0; i < wagons.size(); ++i) {
                            EntityWagon tempWagon = wagons.get(i);
                            if (tempWagon.pulled && tempWagon.puller == this) {
                                f = (float)((double)f + 1.82);
                                Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-tempWagon.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                                passenger.func_70107_b(tempWagon.field_70165_t + vec3d.field_72450_a, tempWagon.field_70163_u + (double)f1, tempWagon.field_70161_v + vec3d.field_72449_c);
                                continue;
                            }
                            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
                        }
                    }
                } else {
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
                }
            } else {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151057_cb) {
            if (!stack.func_82837_s()) {
                return false;
            }
            EntityAnimaniaHorse entityliving = this;
            entityliving.func_96094_a(stack.func_82833_r());
            entityliving.func_110163_bv();
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
                this.eatTimer = 40;
            }
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && this.isHorseBreedingItem(stack.func_77973_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.eatTimer = 40;
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
            }
            this.setFed(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && stack.func_77973_b() == Animania.ridingCrop && !this.func_184207_aI() && this.getWatered() && this.getFed() && !this.func_70631_g_()) {
            this.field_70699_by.func_75499_g();
            player.func_184220_m((Entity)this);
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && this.isHorseBreedingItem(stack.func_77973_b());
    }

    private boolean isHorseBreedingItem(Item itemIn) {
        return itemIn == Items.field_151015_O || itemIn == Items.field_151034_e || itemIn == Items.field_151172_bF;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        compound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setMateUniqueId(UUID.fromString(s));
        }
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setAnimalAge(compound.func_74762_e("Age"));
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.horseDrop;
            dropItem = AnimaniaHelper.getItem(drop);
            if (this.func_70027_ad() && drop.equals(this.dropRaw.getRegistryName().toString())) {
                drop = this.dropCooked.getRegistryName().toString();
                dropItem = AnimaniaHelper.getItem(drop);
            }
        } else {
            dropItem = new ItemStack(this.dropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.dropCooked, 1);
            }
        }
        String drop2 = Animania.horseDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.horseDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1 && dropItem2 != null) {
            if (this.func_70027_ad()) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.horseDrop2Amount + lootlevel);
            } else {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.horseDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 0 && dropItem2 != null) {
            this.func_145779_a(dropItem2.func_77973_b(), Animania.horseDrop2Amount + lootlevel);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

