/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.horses;

import com.animania.Animania;
import com.animania.ModSoundEvents;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.entities.horses.EntityAnimaniaHorse;
import com.animania.entities.horses.EntityMareDraftHorse;
import com.animania.entities.horses.EntityStallionDraftHorse;
import com.animania.entities.horses.HorseType;
import com.animania.entities.horses.ai.EntityAIFollowParentHorses;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFoalBase
extends EntityAnimaniaHorse
implements TOPInfoProviderBase {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O, Items.field_151034_e, Items.field_151172_bF});
    private static final DataParameter<Optional<UUID>> PARENT_UNIQUE_ID = EntityDataManager.func_187226_a(EntityFoalBase.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityFoalBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int ageTimer;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private static final String[] HORSE_TEXTURES = new String[]{"black", "bw1", "bw2", "grey", "red", "white"};

    public EntityFoalBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 3.2f);
        this.field_70138_W = 1.1f;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowParentHorses((EntityAnimal)this, 1.1));
        this.ageTimer = 0;
        this.horseType = HorseType.DRAFT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARENT_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Age", this.getEntityAge());
        if (this.getParentUniqueId() != null && this.getParentUniqueId() != null) {
            compound.func_74778_a("ParentUUID", this.getParentUniqueId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setEntityAge(compound.func_74760_g("Age"));
        if (compound.func_150297_b("ParentUUID", 8)) {
            s = compound.func_74779_i("ParentUUID");
        } else {
            String s1 = compound.func_74779_i("Parent");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setParentUniqueId(UUID.fromString(s));
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.05f, 1.1f);
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 18 : (happy == 1 ? 36 : 60))) == 0) {
            return ModSoundEvents.horseliving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horseliving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.horseliving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.horseliving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.horseliving5;
        }
        return ModSoundEvents.horseliving6;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.horsehurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horsehurt2;
        }
        return ModSoundEvents.horsehurt3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.horsehurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.horsehurt2;
        }
        return ModSoundEvents.horsehurt3;
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() + 0.2f - this.getEntityAge() * 2.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.func_184207_aI()) {
            return 0.0f;
        }
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.func_184207_aI()) {
            return 0.0f;
        }
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 80.0f;
            return 0.62831855f + 0.0439823f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Nullable
    public UUID getParentUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(PARENT_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setParentUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public float getEntityAge() {
        try {
            return this.getFloatFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    public void func_70636_d() {
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.getColorNumber() > 5) {
            this.setColorNumber(0);
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
            }
        }
        this.field_175504_a = -24000;
        ++this.ageTimer;
        if (this.ageTimer >= Animania.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            this.func_70105_a(1.0f + age, 1.4f + age);
            if ((double)age >= 0.45 && !this.field_70170_p.field_72995_K) {
                EntityAnimaniaHorse entityHorse;
                int color = this.getColorNumber();
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    entityHorse = new EntityMareDraftHorse(this.field_70170_p);
                    entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    String name = this.func_95999_t();
                    if (name != "") {
                        entityHorse.func_96094_a(name);
                    }
                    entityHorse.setAnimalAge(1);
                    this.field_70170_p.func_72838_d((Entity)entityHorse);
                    entityHorse.setColorNumber(color);
                    this.func_184185_a(ModSoundEvents.horseliving1, 0.5f, 1.1f);
                } else {
                    entityHorse = new EntityStallionDraftHorse(this.field_70170_p);
                    entityHorse.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    String name = this.func_95999_t();
                    if (name != "") {
                        entityHorse.func_96094_a(name);
                    }
                    entityHorse.setAnimalAge(1);
                    this.field_70170_p.func_72838_d((Entity)entityHorse);
                    entityHorse.setColorNumber(color);
                    this.func_184185_a(ModSoundEvents.horseliving2, 0.5f, 1.1f);
                }
            }
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    public EntityFoalBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }
}

