/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.pigs;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.pigs.PigType;
import com.animania.entities.pigs.ai.EntityAIFindFood;
import com.animania.entities.pigs.ai.EntityAIFindMud;
import com.animania.entities.pigs.ai.EntityAIFindSaltLickPigs;
import com.animania.entities.pigs.ai.EntityAIFindWater;
import com.animania.entities.pigs.ai.EntityAILookIdlePig;
import com.animania.entities.pigs.ai.EntityAIPanicPigs;
import com.animania.entities.pigs.ai.EntityAIPigSnuffle;
import com.animania.entities.pigs.ai.EntityAISwimmingPigs;
import com.animania.entities.pigs.ai.EntityAIWanderPig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAnimaniaPig
extends EntityAnimal {
    protected static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> MUDDY = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SPLASHTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> MUDTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PLAYED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151170_bI});
    protected boolean boosting;
    protected int boostTime;
    protected int totalBoostTime;
    public int eatTimer;
    public EntityAIPigSnuffle entityAIEatGrass;
    protected int fedTimer;
    protected int wateredTimer;
    protected int playedTimer;
    protected int happyTimer = 60;
    public int blinkTimer;
    protected int damageTimer;
    protected ItemStack slop;
    protected PigType pigType;
    protected Item dropRaw = Items.field_151147_al;
    protected Item dropCooked = Items.field_151157_am;
    protected Item oldDropRaw = Items.field_151147_al;
    protected Item oldDropCooked = Items.field_151157_am;
    protected boolean mateable = false;

    public EntityAnimaniaPig(World worldIn) {
        super(worldIn);
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
        this.slop = new ItemStack(Animania.bucketSlop);
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIPigSnuffle(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingPigs((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindMud((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderPig((EntityCreature)this, 1.0));
        if (!Animania.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIPanicPigs((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151146_bM, false));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIFindSaltLickPigs((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILookIdlePig(this));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.setHandFed(true);
        if (this.entityAIEatGrass != null) {
            this.entityAIEatGrass.func_75249_e();
            this.eatTimer = 80;
        }
        player.func_71064_a(this.pigType.getAchievement(), 1);
        if (player.func_189102_a(AnimaniaAchievements.Duroc) && player.func_189102_a(AnimaniaAchievements.Hampshire) && player.func_189102_a(AnimaniaAchievements.LargeBlack) && player.func_189102_a(AnimaniaAchievements.LargeWhite) && player.func_189102_a(AnimaniaAchievements.OldSpot) && player.func_189102_a(AnimaniaAchievements.Yorkshire)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Pigs, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack != null && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop)) {
                --stack.field_77994_a;
            } else if (stack != null && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop)) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
            }
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(MUDDY, (Object)false);
        this.field_70180_af.func_187214_a(MUDTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPLASHTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(PLAYED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Saddle", this.getSaddled());
        compound.func_74757_a("Muddy", this.getMuddy());
        compound.func_74776_a("MudTimer", this.getMudTimer().floatValue());
        compound.func_74776_a("SplashTimer", this.getSplashTimer().floatValue());
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("Played", this.getPlayed());
        compound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.setMuddy(compound.func_74767_n("Muddy"));
        this.setMudTimer(Float.valueOf(compound.func_74760_g("MudTimer")));
        this.setSplashTimer(Float.valueOf(compound.func_74760_g("SplashTimer")));
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setPlayed(compound.func_74767_n("Played"));
        this.setAnimalAge(compound.func_74762_e("Age"));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        EntityPlayer entityplayer = player;
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
                this.eatTimer = 40;
            }
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop)) {
            if (!player.func_184812_l_()) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
            }
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
                this.eatTimer = 40;
            }
            this.setFed(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        this.func_70628_a(wasRecentlyHit, lootingModifier);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getPlayed()) {
            ++happyDrops;
        }
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.pigDrop;
            dropItem = AnimaniaHelper.getItem(drop);
            if (this.func_70027_ad() && drop.equals(this.dropRaw.getRegistryName().toString())) {
                drop = this.dropCooked.getRegistryName().toString();
                dropItem = AnimaniaHelper.getItem(drop);
            }
        } else if (Animania.oldMeatDrops) {
            dropItem = new ItemStack(this.oldDropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.oldDropCooked, 1);
            }
        } else {
            dropItem = new ItemStack(this.dropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.dropCooked, 1);
            }
        }
        String drop2 = Animania.pigDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 3) {
            if (dropItem != null) {
                dropItem.field_77994_a = 2 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.pigDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.pigDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1 && dropItem != null) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151157_am, 1 + lootlevel);
            } else {
                this.func_145779_a(Items.field_151147_al, 1 + lootlevel);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.pigDrop2Amount + lootlevel);
            }
        }
    }

    public boolean getSaddled() {
        try {
            return this.getBoolFromDataManager(SADDLED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)false);
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    public void setSlopFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer * 2 + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getPlayed() {
        try {
            return this.getBoolFromDataManager(PLAYED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPlayed(boolean played) {
        if (played) {
            this.field_70180_af.func_187227_b(PLAYED, (Object)true);
            this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(PLAYED, (Object)false);
        }
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public boolean getMuddy() {
        try {
            return this.getBoolFromDataManager(MUDDY);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setMuddy(boolean muddy) {
        if (muddy) {
            this.field_70180_af.func_187227_b(MUDDY, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(MUDDY, (Object)false);
        }
    }

    public Float getMudTimer() {
        try {
            return Float.valueOf(this.getFloatFromDataManager(MUDTIMER));
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    public void setMudTimer(Float timer) {
        this.field_70180_af.func_187227_b(MUDTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public Float getSplashTimer() {
        try {
            return Float.valueOf(this.getFloatFromDataManager(SPLASHTIMER));
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    public void setSplashTimer(Float timer) {
        this.field_70180_af.func_187227_b(SPLASHTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityPigZombie entitypigzombie = new EntityPigZombie(this.field_70170_p);
            entitypigzombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_94061_f(this.func_175446_cd());
            if (this.func_70631_g_()) {
                entitypigzombie.func_82227_f(true);
            }
            if (this.func_145818_k_()) {
                entitypigzombie.func_96094_a(this.func_95999_t());
                entitypigzombie.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        if (this.playedTimer > -1 && !Animania.ambianceMode) {
            --this.playedTimer;
            if (this.playedTimer == 0) {
                this.setPlayed(false);
            }
        }
        if ((double)this.getMudTimer().floatValue() > 0.0) {
            this.setPlayed(true);
            this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        boolean played = this.getPlayed();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        BlockPos currentpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Block poschk = this.field_70170_p.func_180495_p(currentpos).func_177230_c();
        if (poschk != null && poschk == Animania.blockMud || poschk.func_149739_a().equals("tile.mud")) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, 4, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && !this.getPlayed() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    protected Item func_146068_u() {
        return null;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

