/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.pigs;

import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.compat.top.providers.entity.TOPInfoProviderPig;
import com.animania.entities.pigs.EntityAnimaniaPig;
import com.animania.entities.pigs.EntityHogBase;
import com.animania.entities.pigs.EntityPigletBase;
import com.animania.entities.pigs.PigType;
import com.animania.entities.pigs.ai.EntityAIPanicPigs;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySowBase
extends EntityAnimaniaPig
implements TOPInfoProviderPig {
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187203_m);
    public int dryTimerSow;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySowBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.1f, 1.0f);
        this.field_70138_W = 1.1f;
        this.mateable = true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPanicPigs((EntityCreature)this, 2.0));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaPig)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= Animania.spawnLimitPigs) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityHogBase entityPig = this.pigType.getMale(this.field_70170_p);
                entityPig.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityPig);
                entityPig.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityPig.getPersistentID());
            } else if (chooser == 1 && !Animania.manualBreeding) {
                EntityPigletBase entityPig = this.pigType.getChild(this.field_70170_p);
                entityPig.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityPig);
                entityPig.setParentUniqueId(this.field_96093_i);
            } else if (chooser > 2) {
                EntityHogBase entityPig = this.pigType.getMale(this.field_70170_p);
                entityPig.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityPig);
                entityPig.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityPig.getPersistentID());
                if (!Animania.manualBreeding) {
                    EntityPigletBase entityPiglet = this.pigType.getChild(this.field_70170_p);
                    entityPiglet.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityPiglet);
                    entityPiglet.setParentUniqueId(this.field_96093_i);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(Animania.gestationTimer + this.field_70146_Z.nextInt(200)));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Pregnant", this.getPregnant());
        compound.func_74757_a("HasKids", this.getHasKids());
        compound.func_74757_a("Fertile", this.getFertile());
        compound.func_74768_a("Gestation", this.getGestation());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            String s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            String s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setHasKids(compound.func_74767_n("HasKids"));
        this.setFertile(compound.func_74767_n("Fertile"));
        this.setGestation(compound.func_74762_e("Gestation"));
    }

    public int getGestation() {
        try {
            return this.getIntFromDataManager(GESTATION_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    public boolean getPregnant() {
        try {
            return this.getBoolFromDataManager(PREGNANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(Animania.gestationTimer + this.field_70146_Z.nextInt(500));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    public boolean getFertile() {
        try {
            return this.getBoolFromDataManager(FERTILE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFertile(boolean preggers) {
        this.field_70180_af.func_187227_b(FERTILE, (Object)preggers);
    }

    public boolean getHasKids() {
        try {
            return this.getBoolFromDataManager(HAS_KIDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHasKids(boolean kids) {
        this.field_70180_af.func_187227_b(HAS_KIDS, (Object)kids);
    }

    @Nullable
    public UUID getMateUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.pig1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pig2;
        }
        if (chooser == 2) {
            return ModSoundEvents.pig4;
        }
        if (chooser == 3) {
            return ModSoundEvents.pig5;
        }
        if (chooser == 4) {
            return ModSoundEvents.pig6;
        }
        if (chooser == 5) {
            return ModSoundEvents.pig7;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151146_bM && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (distance > 5.0f) {
            for (EntityPlayer entityplayer : this.func_184180_b(EntityPlayer.class)) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187993_u);
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f;
                if (this.boosting) {
                    if (this.boostTime++ > this.totalBoostTime) {
                        this.boosting = false;
                    }
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_70612_e(0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.getFertile() && this.dryTimerSow > -1) {
            --this.dryTimerSow;
        } else {
            this.setFertile(true);
            this.dryTimerSow = Animania.gestationTimer / 5 + this.field_70146_Z.nextInt(50);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 200 + this.field_70146_Z.nextInt(200);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityHogBase> entities = AnimaniaHelper.getEntitiesInRange(EntityHogBase.class, 20.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        boolean played = this.getPlayed();
        int gestationTimer = this.getGestation();
        if (gestationTimer > -1 && this.getPregnant()) {
            this.setGestation(--gestationTimer);
            if (gestationTimer == 0) {
                List list = this.field_70170_p.field_72996_f;
                int pigCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaPig)) continue;
                    ++num;
                }
                pigCount = num;
                UUID MateID = this.getMateUniqueId();
                List<EntityHogBase> entities = AnimaniaHelper.getEntitiesInRange(EntityHogBase.class, 30.0, this.field_70170_p, (Entity)this);
                int esize = entities.size();
                Boolean mateFound = false;
                for (int k = 0; k <= esize - 1; ++k) {
                    EntityHogBase entity = entities.get(k);
                    if (entity == null || !this.getFed() || !this.getWatered() || !entity.getPersistentID().equals(MateID)) continue;
                    this.func_146082_f(null);
                    PigType maleType = entity.pigType;
                    PigType babyType = PigType.breed(maleType, this.pigType);
                    EntityPigletBase entityPiglet = babyType.getChild(this.field_70170_p);
                    entityPiglet.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityPiglet);
                    }
                    entityPiglet.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.piglet1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entity, (EntityAgeable)entityPiglet);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    k = esize;
                    mateFound = true;
                    break;
                }
                if (!mateFound.booleanValue() && this.getFed() && this.getWatered()) {
                    this.func_146082_f(null);
                    PigType babyType = PigType.breed(this.pigType, this.pigType);
                    EntityPigletBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.piglet1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entityKid, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    mateFound = true;
                }
            }
        } else if (gestationTimer < 0) {
            this.setGestation(1);
        }
        super.func_70636_d();
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntitySowBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && (EntityAnimaniaPig.TEMPTATION_ITEMS.contains(stack.func_77973_b()) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop));
    }
}

