/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.props;

import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.entities.props.AnimatedEntityBase;
import com.animania.inventory.CartChest;
import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.util.Random;

public class EntityWagon
extends AnimatedEntityBase
implements IInventoryChangedListener {
    protected static AnimationHandler animHandler = CraftStudioApi.getNewAnimationHandler(EntityWagon.class);
    public boolean pulled;
    public Entity puller;
    public CartChest wagonChest;
    public float deltaRotation;
    private int lerpSteps;
    private double wagonPitch;
    private double lerpY;
    private double lerpZ;
    public double wagonYaw;
    private double lerpXRot;
    private int sleepDelay = 0;
    private boolean sleepFlag = true;
    private boolean allSleeping = false;
    private int lastLighting = 60;
    private int sleepTimer = 0;
    public int blinkTimer;
    protected static final DataParameter<Integer> PULLER_TYPE = EntityDataManager.func_187226_a(EntityWagon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityWagon.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityWagon.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> HAS_CHEST = EntityDataManager.func_187226_a(EntityWagon.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityWagon(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(2.5f, 1.2f);
        this.field_70138_W = 1.2f;
        this.puller = null;
        this.pulled = false;
        this.initwagonChest();
        this.blinkTimer = 15;
    }

    public EntityWagon(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public AnimationHandler getAnimationHandler() {
        return animHandler;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public double func_70042_X() {
        return 0.9;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        List<EntityHorse> horses = AnimaniaHelper.getEntitiesInRange(EntityHorse.class, 3.0, this.field_70170_p, (Entity)player);
        List<EntityWagon> wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.field_70170_p, this);
        EntityHorse horse = null;
        if (!horses.isEmpty()) {
            horse = horses.get(0);
        }
        double diffx = this.field_70165_t - player.field_70165_t;
        double diffy = this.field_70163_u - player.field_70163_u;
        double diffz = this.field_70161_v - player.field_70161_v;
        double mdiffx = Math.abs(this.field_70165_t - player.field_70165_t);
        double mdiffy = Math.abs(this.field_70163_u - player.field_70163_u);
        double mdiffz = Math.abs(this.field_70161_v - player.field_70161_v);
        if (player.func_70093_af()) {
            if (mdiffx > 0.0 && mdiffx < 2.4 && mdiffy < 1.25 && mdiffz > 0.0 && mdiffz < 2.4) {
                this.wagonChest.func_110133_a(this.func_70005_c_());
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)Animania.instance, Animania.coveredWagonGUI_ID, player.field_70170_p, this.func_145782_y(), 0, 0);
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187657_V, SoundCategory.PLAYERS, 0.7f, 1.0f);
                }
                return true;
            }
            if (!player.func_184218_aH()) {
                player.func_184220_m((Entity)this);
                this.field_184245_j = 20;
                if (this.puller == player) {
                    this.puller = null;
                    this.pulled = false;
                    this.setPullerType(0);
                    this.stopwagon();
                }
                return true;
            }
            return true;
        }
        if (!player.func_70093_af()) {
            if (mdiffx > 0.0 && mdiffx < 1.0 && mdiffy > 1.15 && mdiffy < 1.25 && mdiffz > 0.0 && mdiffz < 1.6) {
                if (this.field_70170_p.field_73011_w.func_76567_e()) {
                    this.sleepFlag = false;
                    this.allSleeping = true;
                    Object player1 = null;
                    for (EntityPlayer player2 : this.field_70170_p.field_73010_i) {
                        if (player2 == player || player2.func_70608_bn()) continue;
                        this.allSleeping = false;
                    }
                    EntityPlayer.SleepResult player$sleepresult = this.trySleep(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), player);
                    if (player$sleepresult == EntityPlayer.SleepResult.OK && this.allSleeping) {
                        this.sleepFlag = true;
                        this.sleepDelay = 0;
                    } else if (player$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                        this.sleepFlag = false;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]));
                    } else if (player$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                        this.sleepFlag = false;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
                    } else if (player$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_HERE) {
                        this.sleepFlag = false;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notHere", new Object[0]));
                    }
                    if (player$sleepresult == EntityPlayer.SleepResult.OK) {
                        this.sleepFlag = true;
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 30, 1, false, false));
                            this.field_70170_p.func_72854_c();
                            Animania.proxy.Sleep(player);
                            player.func_180473_a(this.func_180425_c(), true);
                        }
                        this.sleepTimer = 120;
                    }
                }
                return true;
            }
            if (player.func_184218_aH() && this.puller != player && this.puller != player.func_184187_bx() && player.func_184187_bx() != this) {
                this.pulled = true;
                this.puller = player.func_184187_bx();
                if (this.puller instanceof EntityHorse) {
                    this.setPullerType(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                return true;
            }
            if (player.func_184218_aH() && this.puller == player.func_184187_bx() && player.func_184187_bx() != this) {
                this.pulled = false;
                this.puller = null;
                this.setPullerType(0);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                this.stopwagon();
                return true;
            }
            if ((stack == null || stack.func_77973_b() == Items.field_151058_ca) && horse != null && horse.func_110166_bE() == player) {
                this.pulled = true;
                this.puller = horse;
                this.setPullerType(1);
                horse.func_110160_i(true, false);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151058_ca, 1));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                return true;
            }
            if (stack == null && !player.func_184218_aH() && this.puller != player && this.func_184179_bs() != player && !this.field_70170_p.field_72995_K) {
                if (mdiffx > 0.0 && mdiffy < 2.0 && mdiffz > 0.0) {
                    this.pulled = true;
                    this.puller = player;
                    this.setPullerType(2);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.hitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                    }
                }
                return true;
            }
            if (stack == null && !player.func_184218_aH() && this.puller == player && this.func_184179_bs() != player && !this.field_70170_p.field_72995_K) {
                this.pulled = false;
                this.puller = null;
                this.setPullerType(0);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
                }
                this.stopwagon();
                return true;
            }
            this.pulled = false;
            this.puller = null;
            this.setPullerType(0);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSoundEvents.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
            }
            this.stopwagon();
            return true;
        }
        return true;
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
        }
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setHasChest(boolean hasChest) {
        this.field_70180_af.func_187227_b(HAS_CHEST, (Object)hasChest);
    }

    public boolean getHasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CHEST);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityWagon) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e && !this.pulled) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b && !this.pulled) {
            super.func_70108_f(entityIn);
        }
    }

    public void func_70071_h_() {
        int i;
        EntityAnimal entityanimal;
        EntityPlayer player;
        if (this.blinkTimer > 0) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 15;
            }
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer && this.field_184245_j == 0 && (player = (EntityPlayer)this.func_184179_bs()).func_70093_af()) {
            player.func_70108_f((Entity)this);
            this.func_184210_p();
            player.func_110145_l((Entity)this);
            this.func_184226_ay();
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityAnimal && (entityanimal = (EntityAnimal)this.func_184179_bs()).func_184207_aI() && entityanimal.func_184179_bs() instanceof EntityPlayer) {
            entityanimal.func_70108_f((Entity)this);
            entityanimal.func_184210_p();
            this.func_184210_p();
            entityanimal.func_110145_l((Entity)this);
            entityanimal.func_184226_ay();
            this.func_184226_ay();
        }
        if (this.sleepTimer > 0) {
            --this.sleepTimer;
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer && this.field_184245_j > 19 && this.field_70170_p.field_72995_K) {
            player = (EntityPlayer)this.func_184179_bs();
            player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()})));
        }
        if (this.pulled && this.puller != null && this.field_70170_p.field_72995_K) {
            double movX = Math.abs(this.puller.field_70165_t - this.puller.field_70169_q);
            double movZ = Math.abs(this.puller.field_70161_v - this.puller.field_70166_s);
            double moveThresh = movX + movZ - 1.0;
            if (this.wagonYaw < 0.0 && this.puller.field_70159_w > 0.001 && this.puller.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon", (IAnimated)this);
                }
            } else if (this.wagonYaw > 0.0 && this.puller.field_70159_w < -0.001 && this.puller.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon", (IAnimated)this);
                }
            } else if (this.wagonYaw > 0.0 && this.puller.field_70159_w < -0.001 && this.puller.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon", (IAnimated)this);
                }
            } else if (this.wagonYaw < 0.0 && this.puller.field_70159_w > 0.001 && this.puller.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon", (IAnimated)this);
                }
            } else if (this.wagonYaw < 0.0 && this.puller.field_70159_w < -0.001 && this.puller.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
            } else if (this.wagonYaw > 0.0 && this.puller.field_70159_w > 0.001 && this.puller.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
            } else if (this.wagonYaw > 0.0 && this.puller.field_70159_w > 0.001 && this.puller.field_70179_y < -0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
            } else if (this.wagonYaw < 0.0 && this.puller.field_70159_w < -0.001 && this.puller.field_70179_y > 0.001 && movX + movZ > moveThresh) {
                if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                    this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
                }
                if (!this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                    this.getAnimationHandler().clientStartAnimation("animania", "anim_wagon_back", (IAnimated)this);
                }
            }
        }
        if (this.pulled && this.puller instanceof EntityPlayer) {
            List<EntityWagon> wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.field_70170_p, this);
            EntityPlayer player2 = (EntityPlayer)this.puller;
            int totPulling = 0;
            if (!wagons.isEmpty()) {
                if (wagons.size() >= 0) {
                    for (i = 0; i < wagons.size(); ++i) {
                        EntityWagon tempwagon = wagons.get(i);
                        if (!tempwagon.pulled || tempwagon.puller != player2) continue;
                        ++totPulling;
                    }
                }
                if (totPulling > 0) {
                    player2.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, wagons.size() + 1, false, false));
                }
            }
        }
        if (this.pulled && this.puller instanceof EntityAnimal) {
            List<EntityWagon> wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.field_70170_p, this);
            EntityAnimal animal = (EntityAnimal)this.puller;
            int totPulling = 0;
            if (!wagons.isEmpty()) {
                if (wagons.size() > 1) {
                    for (i = 0; i < wagons.size(); ++i) {
                        EntityWagon tempwagon = wagons.get(i);
                        if (!tempwagon.pulled || tempwagon.puller != animal || tempwagon == this) continue;
                        ++totPulling;
                    }
                }
                if (totPulling > 0) {
                    animal.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, wagons.size() + 1, false, false));
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.pulled) {
            double diffX = this.field_70165_t - this.field_70169_q;
            double diffZ = this.field_70161_v - this.field_70166_s;
            double movX = Math.abs(this.field_70165_t - this.field_70169_q);
            double movZ = Math.abs(this.field_70161_v - this.field_70166_s);
            double moveThresh = 0.008;
            if (diffX < 0.005 && diffZ < 0.005 && movX + movZ < moveThresh && this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
                this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
            }
            if (diffX < 0.005 && diffZ < 0.005 && movX + movZ < moveThresh && this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
                this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
            }
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.pulled && this.puller == null && this.getPullerType() > 0) {
            if (this.getPullerType() == 1) {
                List<EntityHorse> entities = AnimaniaHelper.getEntitiesInRange(EntityHorse.class, 3.0, this.field_70170_p, this);
                if (!entities.isEmpty()) {
                    this.puller = (Entity)entities.get(0);
                    this.pulled = true;
                    this.setPullerType(1);
                }
            } else if (this.getPullerType() == 2) {
                List<EntityPlayer> entities = AnimaniaHelper.getEntitiesInRange(EntityPlayer.class, 3.0, this.field_70170_p, this);
                if (!entities.isEmpty()) {
                    this.puller = (Entity)entities.get(0);
                    this.pulled = true;
                    this.setPullerType(2);
                }
            } else {
                this.pulled = false;
                this.setPullerType(0);
            }
        }
        if (this.pulled && this.puller != null && this.puller.func_184218_aH()) {
            this.puller = this.puller.func_184187_bx();
            if (this.puller instanceof EntityHorse) {
                this.setPullerType(1);
            }
        }
        if (this.puller != null && (Math.abs(this.puller.field_70165_t - this.field_70165_t) > 6.0 || Math.abs(this.puller.field_70161_v - this.field_70161_v) > 6.0)) {
            this.pulled = false;
            this.puller = null;
            this.setPullerType(0);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSoundEvents.unhitch, SoundCategory.PLAYERS, 0.7f, 1.5f);
            this.stopwagon();
        }
        if (this.pulled) {
            double deltaAngle = -Math.atan2(this.puller.field_70165_t - this.field_70165_t, this.puller.field_70161_v - this.field_70161_v);
            Vec3d vec = new Vec3d(this.puller.field_70165_t, this.puller.field_70163_u, this.puller.field_70161_v).func_178788_d(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_178787_e(new Vec3d(0.0, 0.0, -3.2).func_178785_b((float)(-deltaAngle)));
            this.field_70159_w = vec.field_72450_a / 1.01;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c / 1.01;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!this.pulled) {
            this.field_70181_x -= 0.05;
            this.func_70091_d(0.0, this.field_70181_x, 0.0);
        }
        super.func_70071_h_();
        this.tickLerp();
    }

    public void stopwagon() {
        if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon", (IAnimated)this)) {
            this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon", (IAnimated)this);
        }
        if (this.getAnimationHandler().isAnimationActive("animania", "anim_wagon_back", (IAnimated)this)) {
            this.getAnimationHandler().clientStopAnimation("animania", "anim_wagon_back", (IAnimated)this);
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.wagonPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.wagonYaw - (double)this.field_70177_z));
            if (this.puller != null) {
                double deltaAngle = -Math.atan2(this.puller.field_70165_t - this.field_70165_t, this.puller.field_70161_v - this.field_70161_v);
                this.field_70177_z = (float)Math.toDegrees(deltaAngle);
            }
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.wagonPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.wagonYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (passenger instanceof EntityPlayer) {
                f1 = (float)((this.field_70128_L ? (double)0.01f : 1.55) + passenger.func_70033_W());
            }
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            if (passenger instanceof EntityPlayer) {
                f = (float)((double)f + 1.8);
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)0.0f, (float)0.0f);
        if (entityToUpdate instanceof EntityPlayer) {
            f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        }
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76364_f() != null) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76364_f() instanceof EntityPlayer && ((EntityPlayer)source.func_76364_f()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_145778_a(Animania.wagon, 1, 0.0f);
                    if (this.getHasChest()) {
                        InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (IInventory)this.wagonChest);
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        double movX = Math.abs(this.field_70165_t - this.field_70169_q);
        double movZ = Math.abs(this.field_70161_v - this.field_70166_s);
        if (entityIn == this.puller) {
            this.puller.field_70159_w = 0.0;
            this.puller.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            return null;
        }
        if (this.pulled) {
            return null;
        }
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this instanceof EntityWagon) {
            return new ItemStack(Animania.wagon);
        }
        return null;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PULLER_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(HAS_CHEST, (Object)true);
    }

    public int getPullerType() {
        return (Integer)this.field_70180_af.func_187225_a(PULLER_TYPE);
    }

    public void setPullerType(int pullerType) {
        this.field_70180_af.func_187227_b(PULLER_TYPE, (Object)pullerType);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("PullerType", this.getPullerType());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.wagonChest.func_70302_i_(); ++i) {
            ItemStack itemstack = this.wagonChest.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74757_a("HasChest", this.getHasChest());
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setPullerType(compound.func_74762_e("PullerType"));
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.initwagonChest();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.wagonChest.func_70302_i_()) continue;
            this.wagonChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
        this.setHasChest(compound.func_74767_n("HasChest"));
    }

    public int determinePullerType(Entity entity) {
        int pullerType = 0;
        if (entity instanceof EntityHorse) {
            pullerType = 1;
        } else if (entity instanceof EntityPlayer) {
            pullerType = 2;
        }
        return pullerType;
    }

    public void initwagonChest() {
        CartChest horsewagonchest = this.wagonChest;
        this.wagonChest = new CartChest("wagonChest", 54);
        this.wagonChest.func_110133_a(this.func_70005_c_());
        if (horsewagonchest != null) {
            horsewagonchest.func_110132_b(this);
            int i = Math.min(horsewagonchest.func_70302_i_(), this.wagonChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = horsewagonchest.func_70301_a(j);
                if (itemstack == null) continue;
                this.wagonChest.func_70299_a(j, itemstack.func_77946_l());
            }
            horsewagonchest = null;
        }
        this.wagonChest.func_110134_a(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public EntityPlayer.SleepResult trySleep(BlockPos bedLocation, EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        EnumFacing enumfacing = EnumFacing.NORTH;
        if (!world.field_72995_K) {
            if (entityplayer.func_70608_bn() || !entityplayer.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (world.func_72935_r()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = world.func_72872_a(EntityMob.class, new AxisAlignedBB((double)bedLocation.func_177958_n() - 8.0, (double)bedLocation.func_177956_o() - 5.0, (double)bedLocation.func_177952_p() - 8.0, (double)bedLocation.func_177958_n() + 8.0, (double)bedLocation.func_177956_o() + 5.0, (double)bedLocation.func_177952_p() + 8.0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        IBlockState state = null;
        if (world.func_175667_e(bedLocation)) {
            state = world.func_180495_p(bedLocation);
        }
        if (state != null) {
            float f1 = 0.5f + (float)enumfacing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)enumfacing.func_82599_e() * 0.4f;
            entityplayer.func_70107_b((double)((float)bedLocation.func_177958_n() + f1), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + f));
        } else {
            entityplayer.func_70107_b((double)((float)bedLocation.func_177958_n() + 0.5f), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + 0.5f));
        }
        entityplayer.field_71081_bT = bedLocation;
        entityplayer.field_70159_w = 0.0;
        entityplayer.field_70181_x = 0.0;
        entityplayer.field_70179_y = 0.0;
        if (!world.field_72995_K) {
            world.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        Random rand = new Random();
        long time = this.func_130014_f_().func_72820_D() % 24000L;
        if (this.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())));
            if (rand.nextInt(32) == 0 && time > 13000L && this.sleepTimer == 0) {
                this.lastLighting = 85 + rand.nextInt(22);
                return this.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) + this.lastLighting;
            }
            if (this.sleepTimer == 0 || time < 13000L) {
                return this.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) + this.lastLighting;
            }
            return 30;
        }
        return 0;
    }

    public void func_76316_a(InventoryBasic invBasic) {
    }

    static {
        animHandler.addAnim("animania", "anim_wagon", "model_wagon", true);
        animHandler.addAnim("animania", "anim_wagon_back", "anim_wagon");
    }
}

