/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.rodents;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.capabilities.CapabilityRefs;
import com.animania.capabilities.ICapabilityPlayer;
import com.animania.compat.top.providers.entity.TOPInfoProviderRodent;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.EntityGender;
import com.animania.entities.ISpawnable;
import com.animania.entities.amphibians.EntityAmphibian;
import com.animania.entities.amphibians.EntityFrogs;
import com.animania.entities.amphibians.EntityToad;
import com.animania.entities.chickens.EntityChickLeghorn;
import com.animania.entities.chickens.EntityChickOrpington;
import com.animania.entities.chickens.EntityChickPlymouthRock;
import com.animania.entities.chickens.EntityChickRhodeIslandRed;
import com.animania.entities.chickens.EntityChickWyandotte;
import com.animania.entities.rodents.FerretType;
import com.animania.entities.rodents.ai.EntityAIFerretFindFood;
import com.animania.entities.rodents.ai.EntityAIFindWater;
import com.animania.entities.rodents.ai.EntityAILookIdleRodent;
import com.animania.entities.rodents.ai.EntityAIRodentEat;
import com.animania.entities.rodents.ai.EntityAISwimmingRodents;
import com.animania.entities.rodents.ai.EntityAITemptRodents;
import com.animania.entities.rodents.ai.EntityAIWanderRodent;
import com.animania.entities.rodents.ai.EntityAIWatchClosestFromSide;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFerretBase
extends EntityTameable
implements TOPInfoProviderRodent,
ISpawnable {
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> RIDING = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> AGE = EntityDataManager.func_187226_a(EntityFerretBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_179561_bm, Items.field_151110_aK, Animania.brownEgg, Items.field_151076_bf, Animania.rawWyandotteChicken, Animania.rawRhodeIslandRedChicken, Animania.rawRhodeIslandRedChicken, Animania.rawOrpingtonChicken, Animania.rawPrimeChicken});
    protected int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    protected int tamedTimer;
    public int blinkTimer;
    public int eatTimer;
    public EntityAIRodentEat entityAIEatGrass;
    protected int damageTimer;
    protected FerretType type;

    public EntityFerretBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 0.4f);
        this.field_70138_W = 1.1f;
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.tamedTimer = 120;
        this.blinkTimer = 70 + this.field_70146_Z.nextInt(70);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingRodents((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.entityAIEatGrass = new EntityAIRodentEat((EntityLiving)this);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFerretFindFood((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIRodentEat((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAITemptRodents((EntityTameable)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWanderRodent((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAILookIdleRodent((EntityAnimal)this));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        if (Animania.animalsCanAttackOthers) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChickLeghorn.class, false));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChickOrpington.class, false));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChickPlymouthRock.class, false));
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChickRhodeIslandRed.class, false));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChickWyandotte.class, false));
            this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySilverfish.class, false));
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFrogs.class, false));
            this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityToad.class, false));
            this.field_70715_bh.func_75776_a(9, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.func_184754_b(player.getPersistentID());
        this.setIsTamed(true);
        this.func_70903_f(true);
        this.func_70904_g(false);
        this.setFerretSitting(false);
        player.func_71064_a(this.type.getAchievement(), 1);
        this.entityAIEatGrass.func_75249_e();
        if (player.func_189102_a(AnimaniaAchievements.WhiteFerret) && player.func_189102_a(AnimaniaAchievements.GreyFerret)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Ferrets, 1);
        }
        if (!player.field_71075_bZ.field_75098_d && stack != null) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.ferretDrop;
            dropItem = AnimaniaHelper.getItem(drop);
        } else {
            dropItem = null;
        }
        String drop2 = Animania.ferretDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.ferretDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.ferretDrop2Amount + lootlevel);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151057_cb) {
            if (!stack.func_82837_s()) {
                return false;
            }
            EntityFerretBase entityliving = this;
            entityliving.func_96094_a(stack.func_82833_r());
            entityliving.func_110163_bv();
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            this.setIsTamed(true);
            this.func_70903_f(true);
            this.func_184754_b(player.getPersistentID());
            return true;
        }
        if (stack == null && this.func_70909_n() && !this.isFerretSitting() && !player.func_70093_af()) {
            this.setFerretSitting(true);
            this.func_70904_g(true);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return true;
        }
        if (stack == null && this.func_70909_n() && this.isFerretSitting() && !player.func_70093_af()) {
            this.setFerretSitting(false);
            this.func_70904_g(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return true;
        }
        if (stack == null && this.func_70909_n() && !this.func_184218_aH() && player.func_70093_af()) {
            if (!this.isFerretRiding()) {
                ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(player);
                props.setMounted(true);
                props.setPetName(this.func_95999_t());
                props.setPetType("FerretGrey");
                this.setFerretRiding(true);
            }
            return this.interactRide(player);
        }
        if (stack == null && this.func_70909_n() && this.func_184218_aH() && player.func_70093_af()) {
            if (this.isFerretRiding()) {
                this.setFerretRiding(false);
                ICapabilityPlayer props = CapabilityRefs.getPlayerCaps(player);
                props.setMounted(false);
            }
            return this.interactRide(player);
        }
        return super.func_184645_a(player, hand, stack);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityAmphibian) {
            this.setFed(true);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(RIDING, (Object)false);
        this.field_70180_af.func_187214_a(AGE, (Object)false);
    }

    public boolean getAnimalAge() {
        try {
            return this.getBoolFromDataManager(AGE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAnimalAge(boolean age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("IsTamed", this.getIsTamed());
        compound.func_74757_a("IsSitting", this.isFerretSitting());
        compound.func_74757_a("Riding", this.isFerretRiding());
        compound.func_74757_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFed(compound.func_74767_n("Fed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setIsTamed(compound.func_74767_n("IsTamed"));
        this.setFerretSitting(compound.func_74767_n("IsSitting"));
        this.setFerretRiding(compound.func_74767_n("Riding"));
        this.setAnimalAge(compound.func_74767_n("Age"));
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.ferretLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.ferretLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.ferretLiving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.ferretLiving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.ferretLiving5;
        }
        if (chooser == 5) {
            return ModSoundEvents.ferretLiving6;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.ferretHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.ferretHurt1;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.ferretHurt1;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.5f);
    }

    private boolean interactRide(EntityPlayer entityplayer) {
        this.isRemoteMountEntity((Entity)entityplayer);
        return true;
    }

    private void isRemoteMountEntity(Entity par1Entity) {
        if (this.isFerretRiding()) {
            this.setFerretRiding(true);
            this.func_184220_m(par1Entity);
        } else if (!this.isFerretRiding()) {
            this.func_184210_p();
        }
    }

    public void func_70636_d() {
        double d2;
        double d1;
        double d;
        if (!this.getAnimalAge()) {
            this.setAnimalAge(true);
        }
        if (this.isFerretSitting() || this.func_184218_aH()) {
            if (this.func_184187_bx() != null) {
                this.field_70177_z = this.func_184187_bx().field_70177_z;
            }
            this.field_70699_by.func_75499_g();
            this.field_70699_by.func_75489_a(0.0);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    d = this.field_70146_Z.nextGaussian() * 0.001;
                    d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.getIsTamed() && Animania.showUnhappyParticles) {
                    d = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isFerretSitting() {
        try {
            return this.getBoolFromDataManager(SITTING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFerretSitting(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SITTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SITTING, (Object)false);
        }
    }

    public boolean isFerretRiding() {
        try {
            return this.getBoolFromDataManager(RIDING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFerretRiding(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(RIDING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(RIDING, (Object)false);
        }
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public boolean getIsTamed() {
        try {
            return this.getBoolFromDataManager(TAMED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsTamed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 176 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 176) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityFerretBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public Item getSpawnEgg() {
        return null;
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return null;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

