/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.rodents.rabbits;

import com.animania.Animania;
import com.animania.AnimaniaHelper;
import com.animania.ModSoundEvents;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.entities.EntityGender;
import com.animania.entities.rodents.rabbits.EntityAnimaniaRabbit;
import com.animania.entities.rodents.rabbits.EntityRabbitBuckBase;
import com.animania.entities.rodents.rabbits.EntityRabbitKitBase;
import com.animania.entities.rodents.rabbits.RabbitType;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRabbitDoeBase
extends EntityAnimaniaRabbit
implements TOPInfoProviderMateable {
    public int dryTimerDoe;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityRabbitDoeBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntityRabbitDoeBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityRabbitDoeBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityRabbitDoeBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityRabbitDoeBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.6f);
        this.field_70138_W = 1.1f;
        this.mateable = true;
        this.gender = EntityGender.FEMALE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(Animania.gestationTimer + this.field_70146_Z.nextInt(200)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Pregnant", this.getPregnant());
        compound.func_74757_a("HasKids", this.getHasKids());
        compound.func_74757_a("Fertile", this.getFertile());
        compound.func_74768_a("Gestation", this.getGestation());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setHasKids(compound.func_74767_n("HasKids"));
        this.setFertile(compound.func_74767_n("Fertile"));
        this.setGestation(compound.func_74762_e("Gestation"));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaRabbit)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= Animania.spawnLimitRabbits) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityRabbitBuckBase entityRabbit = this.rabbitType.getMale(this.field_70170_p);
                entityRabbit.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityRabbit);
                entityRabbit.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityRabbit.getPersistentID());
            } else if (chooser == 1 && !Animania.manualBreeding) {
                EntityRabbitKitBase entityKid = this.rabbitType.getChild(this.field_70170_p);
                entityKid.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityKid);
                entityKid.setParentUniqueId(this.field_96093_i);
            } else if (chooser > 2) {
                EntityRabbitBuckBase entityBuck = this.rabbitType.getMale(this.field_70170_p);
                entityBuck.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityBuck);
                entityBuck.setMateUniqueId(this.field_96093_i);
                this.setMateUniqueId(entityBuck.getPersistentID());
                if (!Animania.manualBreeding) {
                    EntityRabbitKitBase entityKid = this.rabbitType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityKid);
                    entityKid.setParentUniqueId(this.field_96093_i);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    public int getGestation() {
        try {
            return this.getIntFromDataManager(GESTATION_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    public boolean getPregnant() {
        try {
            return this.getBoolFromDataManager(PREGNANT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(Animania.gestationTimer + this.field_70146_Z.nextInt(200));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    public boolean getFertile() {
        try {
            return this.getBoolFromDataManager(FERTILE);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFertile(boolean fertile) {
        this.field_70180_af.func_187227_b(FERTILE, (Object)fertile);
    }

    public boolean getHasKids() {
        try {
            return this.getBoolFromDataManager(HAS_KIDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHasKids(boolean kids) {
        this.field_70180_af.func_187227_b(HAS_KIDS, (Object)kids);
    }

    @Override
    @Nullable
    public UUID getMateUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 8 : (happy == 1 ? 16 : 32))) == 0) {
            return ModSoundEvents.rabbit1;
        }
        if (chooser == 1) {
            return ModSoundEvents.rabbit2;
        }
        if (chooser == 2) {
            return ModSoundEvents.rabbit3;
        }
        if (chooser == 3) {
            return ModSoundEvents.rabbit4;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.rabbitHurt1;
        }
        return ModSoundEvents.rabbitHurt2;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.rabbitHurt1;
        }
        return ModSoundEvents.rabbitHurt2;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.8f);
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.getFertile() && this.dryTimerDoe > -1) {
            --this.dryTimerDoe;
        } else {
            this.setFertile(true);
            this.dryTimerDoe = Animania.gestationTimer / 5 + this.field_70146_Z.nextInt(50);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 200 + this.field_70146_Z.nextInt(200);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityRabbitBuckBase> entities = AnimaniaHelper.getEntitiesInRange(EntityRabbitBuckBase.class, 30.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                    if (!this.getFertile() && !this.getPregnant()) {
                        this.setFertile(true);
                    }
                }
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        int gestationTimer = this.getGestation();
        if (gestationTimer > -1 && this.getPregnant()) {
            this.setGestation(--gestationTimer);
            if (gestationTimer == 0) {
                List list = this.field_70170_p.field_72996_f;
                int rabbitCount = 0;
                int num = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EntityAnimaniaRabbit)) continue;
                    ++num;
                }
                rabbitCount = num;
                UUID MateID = this.getMateUniqueId();
                List<EntityRabbitBuckBase> entities = AnimaniaHelper.getEntitiesInRange(EntityRabbitBuckBase.class, 30.0, this.field_70170_p, (Entity)this);
                int esize = entities.size();
                Boolean mateFound = false;
                for (int k = 0; k <= esize - 1; ++k) {
                    EntityRabbitBuckBase entity = entities.get(k);
                    if (entity == null || !this.getFed() || !this.getWatered() || !entity.getPersistentID().equals(MateID)) continue;
                    this.func_146082_f(null);
                    RabbitType maleType = entity.rabbitType;
                    RabbitType babyType = RabbitType.breed(maleType, this.rabbitType);
                    EntityRabbitKitBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.rabbit1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entity, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    k = esize;
                    mateFound = true;
                    break;
                }
                if (!mateFound.booleanValue() && this.getFed() && this.getWatered()) {
                    this.func_146082_f(null);
                    RabbitType babyType = RabbitType.breed(this.rabbitType, this.rabbitType);
                    EntityRabbitKitBase entityKid = babyType.getChild(this.field_70170_p);
                    entityKid.func_70107_b(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entityKid);
                    }
                    entityKid.setParentUniqueId(this.getPersistentID());
                    this.func_184185_a(ModSoundEvents.rabbit1, 0.5f, 1.1f);
                    this.setPregnant(false);
                    this.setFertile(false);
                    this.setHasKids(true);
                    BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this, (EntityLiving)entityKid, (EntityAgeable)entityKid);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    mateFound = true;
                }
            }
        } else if (gestationTimer < 0) {
            this.setGestation(1);
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.entityAIEatGrass.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && EntityAnimaniaRabbit.TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

