/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.sheep;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.AnimaniaHelper;
import com.animania.entities.AnimalContainer;
import com.animania.entities.EntityAnimaniaAvoidWater;
import com.animania.entities.EntityGender;
import com.animania.entities.ISpawnable;
import com.animania.entities.sheep.EntityEweDorset;
import com.animania.entities.sheep.EntityEweFriesian;
import com.animania.entities.sheep.EntityEweJacob;
import com.animania.entities.sheep.EntityEweMerino;
import com.animania.entities.sheep.EntityEweSuffolk;
import com.animania.entities.sheep.EntityLambDorset;
import com.animania.entities.sheep.EntityLambFriesian;
import com.animania.entities.sheep.EntityLambMerino;
import com.animania.entities.sheep.EntityLambSuffolk;
import com.animania.entities.sheep.EntityRamDorset;
import com.animania.entities.sheep.EntityRamFriesian;
import com.animania.entities.sheep.EntityRamJacob;
import com.animania.entities.sheep.EntityRamMerino;
import com.animania.entities.sheep.EntityRamSuffolk;
import com.animania.entities.sheep.SheepType;
import com.animania.entities.sheep.ai.EntityAIFindFood;
import com.animania.entities.sheep.ai.EntityAIFindSaltLickSheep;
import com.animania.entities.sheep.ai.EntityAIFindWater;
import com.animania.entities.sheep.ai.EntityAIPanicSheep;
import com.animania.entities.sheep.ai.EntityAISheepEatGrass;
import com.animania.entities.sheep.ai.EntityAISwimmingSheep;
import com.animania.items.ItemEntityEgg;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaSheep
extends EntitySheep
implements ISpawnable,
IShearable {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151034_e, Items.field_151172_bF, Items.field_185164_cV, Items.field_151015_O});
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> RIVAL_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SHEARED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String[] SHEEP_TEXTURES = new String[]{"black", "white", "brown"};
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public SheepType sheepType;
    protected Item dropRaw = Items.field_179561_bm;
    protected Item dropCooked = Items.field_179557_bn;
    public EntityAISheepEatGrass field_146087_bs;
    protected boolean mateable = false;
    protected boolean headbutting = false;
    protected EntityGender gender;

    public EntityAnimaniaSheep(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_146087_bs = new EntityAISheepEatGrass((EntityLiving)this);
        if (!Animania.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.1));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimmingSheep((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPanicSheep((EntityCreature)this, 1.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.field_146087_bs);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAnimaniaAvoidWater((EntityCreature)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIFindSaltLickSheep((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(RIVAL_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SHEARED_TIMER, (Object)(Animania.woolRegrowthTimer + this.field_70146_Z.nextInt(500)));
        if (this instanceof EntityRamFriesian || this instanceof EntityEweFriesian || this instanceof EntityLambFriesian) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(3));
        } else if (this instanceof EntityRamDorset || this instanceof EntityEweDorset || this instanceof EntityLambDorset) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof EntityRamMerino || this instanceof EntityEweMerino || this instanceof EntityLambMerino) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof EntityRamSuffolk || this instanceof EntityEweSuffolk || this instanceof EntityLambSuffolk) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)0);
        }
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public int getAnimalAge() {
        try {
            return this.getIntFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAnimalAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public EntityAnimaniaSheep createChild(EntityAgeable ageable) {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.setHandFed(true);
        this.field_146087_bs.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a(this.sheepType.getAchievement(), 1);
        if (player.func_189102_a(AnimaniaAchievements.Dorper) && player.func_189102_a(AnimaniaAchievements.Dorset) && player.func_189102_a(AnimaniaAchievements.FriesianSheep) && player.func_189102_a(AnimaniaAchievements.Jacob) && player.func_189102_a(AnimaniaAchievements.Merino) && player.func_189102_a(AnimaniaAchievements.Suffolk)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Sheep, 1);
        }
        if (!player.func_184812_l_()) {
            --stack.field_77994_a;
        }
    }

    public boolean func_70892_o() {
        try {
            return this.getBoolFromDataManager(SHEARED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_70893_e(boolean sheared) {
        if (sheared) {
            this.field_70180_af.func_187227_b(SHEARED, (Object)true);
            this.setWoolRegrowthTimer(Animania.woolRegrowthTimer + this.field_70146_Z.nextInt(500));
        } else {
            this.field_70180_af.func_187227_b(SHEARED, (Object)false);
        }
    }

    public int getWoolRegrowthTimer() {
        try {
            return this.getIntFromDataManager(SHEARED_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setWoolRegrowthTimer(int time) {
        this.field_70180_af.func_187227_b(SHEARED_TIMER, (Object)time);
    }

    public boolean getFed() {
        try {
            return this.getBoolFromDataManager(FED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getHandFed() {
        try {
            return this.getBoolFromDataManager(HANDFED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setHandFed(boolean handfed) {
        this.field_70180_af.func_187227_b(HANDFED, (Object)handfed);
    }

    public boolean getWatered() {
        try {
            return this.getBoolFromDataManager(WATERED);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_70619_bc() {
        this.eatTimer = this.field_146087_bs.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70636_d() {
        boolean sheared;
        if (this.getAnimalAge() == 0) {
            this.setAnimalAge(1);
        }
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        if (this.fedTimer > -1 && !Animania.ambianceMode) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0 && !Animania.ambianceMode) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        } else if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (sheared = this.func_70892_o()) {
            int shearedTimer = this.getWoolRegrowthTimer();
            this.setWoolRegrowthTimer(--shearedTimer);
            if (shearedTimer < 0) {
                this.func_70893_e(false);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemShears && !this.func_70892_o() && !this.func_70631_g_() && !this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        }
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (stack.field_77994_a == 1 && !player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.field_146087_bs.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151133_ar) {
            return false;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public UUID getMateUniqueId() {
        if (this.mateable) {
            try {
                UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Handfed", this.getHandFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        compound.func_74768_a("Age", this.getAnimalAge());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            String s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            String s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        this.setFed(compound.func_74767_n("Fed"));
        this.setHandFed(compound.func_74767_n("Handfed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setAnimalAge(compound.func_74762_e("Age"));
    }

    public int getColorNumber() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_NUM);
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        ItemStack dropItem;
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (Animania.customMobDrops) {
            String drop = Animania.sheepDrop;
            dropItem = AnimaniaHelper.getItem(drop);
            if (this.func_70027_ad() && drop.equals(this.dropRaw.getRegistryName().toString())) {
                drop = this.dropCooked.getRegistryName().toString();
                dropItem = AnimaniaHelper.getItem(drop);
            }
        } else {
            dropItem = new ItemStack(this.dropRaw, 1);
            if (this.func_70027_ad()) {
                dropItem = new ItemStack(this.dropCooked, 1);
            }
        }
        ItemStack woolItem = new ItemStack(Blocks.field_150325_L, 1);
        if (this.func_70892_o()) {
            woolItem = null;
        } else if (this instanceof EntityRamFriesian || this instanceof EntityEweFriesian) {
            switch (this.getColorNumber()) {
                case 0: {
                    woolItem = new ItemStack(Animania.blockWoolFriesianBlack, 1);
                    break;
                }
                case 1: {
                    woolItem = new ItemStack(Blocks.field_150325_L, 1);
                    break;
                }
                case 2: {
                    woolItem = new ItemStack(Animania.blockWoolFriesianBrown, 1);
                }
            }
        } else if (this instanceof EntityRamSuffolk || this instanceof EntityEweSuffolk) {
            switch (this.getColorNumber()) {
                case 0: {
                    woolItem = new ItemStack(Blocks.field_150325_L, 1);
                    break;
                }
                case 1: {
                    woolItem = new ItemStack(Item.func_150898_a((Block)Animania.blockWoolSuffolkBrown), 1);
                }
            }
        } else if (this instanceof EntityRamDorset || this instanceof EntityEweDorset) {
            switch (this.getColorNumber()) {
                case 0: {
                    woolItem = new ItemStack(Blocks.field_150325_L, 1);
                    break;
                }
                case 1: {
                    woolItem = new ItemStack(Item.func_150898_a((Block)Animania.blockWoolDorsetBrown), 1);
                }
            }
        } else if (this instanceof EntityRamMerino || this instanceof EntityEweMerino) {
            switch (this.getColorNumber()) {
                case 0: {
                    woolItem = new ItemStack(Item.func_150898_a((Block)Animania.blockWoolMerinoWhite), 1);
                    break;
                }
                case 1: {
                    woolItem = new ItemStack(Item.func_150898_a((Block)Animania.blockWoolMerinoBrown), 1);
                }
            }
        } else if (this instanceof EntityRamJacob || this instanceof EntityEweJacob) {
            switch (this.getColorNumber()) {
                case 0: {
                    woolItem = new ItemStack(Item.func_150898_a((Block)Animania.blockWoolJacob), 1);
                }
            }
        } else {
            woolItem = new ItemStack(Blocks.field_150325_L, 1);
        }
        String drop2 = Animania.sheepDrop2;
        ItemStack dropItem2 = AnimaniaHelper.getItem(drop2);
        if (happyDrops == 2) {
            if (dropItem != null) {
                dropItem.field_77994_a = 1 + lootlevel;
            }
            if (woolItem != null) {
                woolItem.field_77994_a = 1 + lootlevel;
                this.func_70099_a(woolItem, 0.5f);
            }
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, dropItem);
            this.field_70170_p.func_72838_d((Entity)entityitem);
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.sheepDrop2Amount + lootlevel);
            }
        } else if (happyDrops == 1) {
            if (this.func_70027_ad()) {
                if (woolItem != null) {
                    woolItem.field_77994_a = 1 + lootlevel;
                    this.func_70099_a(woolItem, 0.5f);
                }
                this.func_145779_a(Items.field_179561_bm, 1 + lootlevel);
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.sheepDrop2Amount + lootlevel);
                }
            } else {
                if (woolItem != null) {
                    woolItem.field_77994_a = 1 + lootlevel;
                    this.func_70099_a(woolItem, 0.5f);
                }
                this.func_145779_a(Items.field_179561_bm, 1 + lootlevel);
                if (dropItem2 != null) {
                    this.func_145779_a(dropItem2.func_77973_b(), Animania.sheepDrop2Amount + lootlevel);
                }
            }
        } else if (happyDrops == 0) {
            if (woolItem != null) {
                woolItem.field_77994_a = 1 + lootlevel;
                this.func_70099_a(woolItem, 0.5f);
            }
            if (dropItem2 != null) {
                this.func_145779_a(dropItem2.func_77973_b(), Animania.sheepDrop2Amount + lootlevel);
            }
        }
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.sheepType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.func_70892_o() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return null;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public boolean usesEggColor() {
        return true;
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }
}

