/*
 * Decompiled with CFR 0.152.
 */
package com.animania.render.cows;

import com.animania.entities.cows.EntityCalfHolstein;
import com.animania.models.ModelCalf;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCalfHolstein
extends RenderLiving<EntityCalfHolstein> {
    private static final ResourceLocation cowTextures = new ResourceLocation("animania:textures/entity/cows/calf_holstein.png");
    private static final ResourceLocation cowTexturesBlink = new ResourceLocation("animania:textures/entity/cows/calf_holstein_blink.png");
    Random rand = new Random();

    public RenderCalfHolstein(RenderManager rm) {
        super(rm, (ModelBase)new ModelCalf(), 0.5f);
    }

    protected ResourceLocation getCowTextures(EntityCalfHolstein par1EntityCow) {
        return cowTextures;
    }

    protected ResourceLocation getCowTexturesBlink(EntityCalfHolstein par1EntityCow) {
        return cowTexturesBlink;
    }

    protected void preRenderCallback(EntityCalfHolstein entityliving, float f) {
        this.preRenderScale(entityliving, f);
    }

    protected void preRenderScale(EntityCalfHolstein entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(1.0f + age), (float)(1.0f + age), (float)(1.0f + age));
    }

    protected ResourceLocation getEntityTexture(EntityCalfHolstein par1Entity) {
        EntityCalfHolstein entity = par1Entity;
        int blinkTimer = entity.blinkTimer;
        if (blinkTimer < 7 && blinkTimer >= 0) {
            return this.getCowTexturesBlink(entity);
        }
        return this.getCowTextures(entity);
    }
}

